/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.huaweicloud.dms;

import com.huaweicloud.sdk.core.ClientBuilder;
import com.huaweicloud.sdk.core.HcClient;
import org.apache.camel.component.huaweicloud.dms.DmsMeta;
import org.apache.camel.component.huaweicloud.dms.models.CreateInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.CreateInstanceResponse;
import org.apache.camel.component.huaweicloud.dms.models.DeleteInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.DeleteInstanceResponse;
import org.apache.camel.component.huaweicloud.dms.models.DmsInstance;
import org.apache.camel.component.huaweicloud.dms.models.ListInstancesRequest;
import org.apache.camel.component.huaweicloud.dms.models.ListInstancesResponse;
import org.apache.camel.component.huaweicloud.dms.models.QueryInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.UpdateInstanceRequest;
import org.apache.camel.component.huaweicloud.dms.models.UpdateInstanceResponse;

public class DmsClient {
    protected HcClient hcClient;

    public DmsClient(HcClient hcClient) {
        this.hcClient = hcClient;
    }

    public static ClientBuilder<DmsClient> newBuilder() {
        return new ClientBuilder(DmsClient::new);
    }

    public CreateInstanceResponse createInstance(CreateInstanceRequest request) {
        return (CreateInstanceResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, DmsMeta.CREATE_INSTANCE));
    }

    public DeleteInstanceResponse deleteInstance(DeleteInstanceRequest request) {
        return (DeleteInstanceResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, DmsMeta.DELETE_INSTANCE));
    }

    public ListInstancesResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, DmsMeta.LIST_INSTANCES));
    }

    public DmsInstance queryInstance(QueryInstanceRequest request) {
        return (DmsInstance)((Object)this.hcClient.syncInvokeHttp((Object)request, DmsMeta.QUERY_INSTANCE));
    }

    public UpdateInstanceResponse updateInstance(UpdateInstanceRequest request) {
        return (UpdateInstanceResponse)((Object)this.hcClient.syncInvokeHttp((Object)request, DmsMeta.UPDATE_INSTANCE));
    }
}

