/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast;

import org.apache.camel.spi.Metadata;

public final class HazelcastConstants {
    public static final String SCHEME_ATOMIC_VALUE = "hazelcast-atomicvalue";
    public static final String SCHEME_INSTANCE = "hazelcast-instance";
    public static final String SCHEME_LIST = "hazelcast-list";
    public static final String SCHEME_MAP = "hazelcast-map";
    public static final String SCHEME_MULTIMAP = "hazelcast-multimap";
    public static final String SCHEME_QUEUE = "hazelcast-queue";
    public static final String SCHEME_REPLICATED_MAP = "hazelcast-replicatedmap";
    public static final String SCHEME_RING_BUFFER = "hazelcast-ringbuffer";
    public static final String SCHEME_SEDA = "hazelcast-seda";
    public static final String SCHEME_SET = "hazelcast-set";
    public static final String SCHEME_TOPIC = "hazelcast-topic";
    public static final String MAP_PREFIX = "map:";
    public static final String MULTIMAP_PREFIX = "multimap:";
    public static final String REPLICATEDMAP_PREFIX = "replicatedmap:";
    public static final String ATOMICNUMBER_PREFIX = "atomicvalue:";
    public static final String INSTANCE_PREFIX = "instance:";
    public static final String QUEUE_PREFIX = "queue:";
    public static final String TOPIC_PREFIX = "topic:";
    public static final String SEDA_PREFIX = "seda:";
    public static final String LIST_PREFIX = "list:";
    public static final String SET_PREFIX = "set:";
    public static final String RINGBUFFER_PREFIX = "ringbuffer:";
    @Metadata(description="the object id to store / find your object inside the cache", javaType="String", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic"})
    public static final String OBJECT_ID = "CamelHazelcastObjectId";
    @Metadata(label="producer", description="The index of the object", javaType="Integer", applicableFor={"hazelcast-list"})
    public static final String OBJECT_POS = "CamelHazelcastObjectIndex";
    @Metadata(label="producer", description="The old value", javaType="Object", applicableFor={"hazelcast-map"})
    public static final String OBJECT_VALUE = "CamelHazelcastObjectValue";
    @Metadata(label="producer", description="The value of the TTL", javaType="Integer", applicableFor={"hazelcast-map"})
    public static final String TTL_VALUE = "CamelHazelcastObjectTtlValue";
    @Metadata(label="producer", description="The value of time unit ( DAYS / HOURS / MINUTES / ....", javaType="java.util.concurrent.TimeUnit", applicableFor={"hazelcast-map"})
    public static final String TTL_UNIT = "CamelHazelcastObjectTtlUnit";
    @Metadata(label="producer", description="The query to execute against the map with a sql like syntax (see http://www.hazelcast.com/)", javaType="String", applicableFor={"hazelcast-map"})
    public static final String QUERY = "CamelHazelcastQuery";
    public static final String EXPECTED_VALUE = "CamelHazelcastExpectedValue";
    @Metadata(label="producer", description="The collection to transfer elements into", javaType="Collection", applicableFor={"hazelcast-queue"})
    public static final String DRAIN_TO_COLLECTION = "CamelHazelcastDrainToCollection";
    @Metadata(label="consumer", description="The type of event - here *added* and *removed*", javaType="String", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic", "hazelcast-instance"})
    public static final String LISTENER_ACTION = "CamelHazelcastListenerAction";
    @Metadata(label="consumer", description="The map consumer", javaType="String", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic", "hazelcast-instance"})
    public static final String LISTENER_TYPE = "CamelHazelcastListenerType";
    @Metadata(label="consumer", description="The time of the event in millis", javaType="Long", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic", "hazelcast-instance"})
    public static final String LISTENER_TIME = "CamelHazelcastListenerTime";
    @Metadata(label="consumer", description="The host name of the instance", javaType="String", applicableFor={"hazelcast-instance"})
    public static final String INSTANCE_HOST = "CamelHazelcastInstanceHost";
    @Metadata(label="consumer", description="The port number of the instance", javaType="Integer", applicableFor={"hazelcast-instance"})
    public static final String INSTANCE_PORT = "CamelHazelcastInstancePort";
    @Metadata(label="consumer", description="The name of the cache - e.g. \"foo\"", javaType="String", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic"})
    public static final String CACHE_NAME = "CamelHazelcastCacheName";
    @Metadata(description="The type of the cache - here multimap", javaType="String", applicableFor={"hazelcast-multimap"})
    public static final String CACHE_TYPE = "CamelHazelcastCacheType";
    @Metadata(label="producer", description="The operation to perform", javaType="String", applicableFor={"hazelcast-multimap", "hazelcast-replicatedmap", "hazelcast-list", "hazelcast-queue", "hazelcast-set", "hazelcast-map", "hazelcast-topic", "hazelcast-atomicvalue", "hazelcast-ringbuffer"})
    public static final String OPERATION = "CamelHazelcastOperationType";
    @Deprecated
    public static final String PUT_OPERATION = "put";
    @Deprecated
    public static final String DELETE_OPERATION = "delete";
    @Deprecated
    public static final String GET_OPERATION = "get";
    @Deprecated
    public static final String UPDATE_OPERATION = "update";
    @Deprecated
    public static final String QUERY_OPERATION = "query";
    @Deprecated
    public static final String GET_ALL_OPERATION = "getAll";
    @Deprecated
    public static final String CLEAR_OPERATION = "clear";
    @Deprecated
    public static final String PUT_IF_ABSENT_OPERATION = "putIfAbsent";
    @Deprecated
    public static final String ADD_ALL_OPERATION = "addAll";
    @Deprecated
    public static final String REMOVE_ALL_OPERATION = "removeAll";
    @Deprecated
    public static final String RETAIN_ALL_OPERATION = "retailAll";
    @Deprecated
    public static final String EVICT_OPERATION = "evict";
    @Deprecated
    public static final String EVICT_ALL_OPERATION = "evictAll";
    @Deprecated
    public static final String VALUE_COUNT_OPERATION = "valueCount";
    @Deprecated
    public static final String CONTAINS_KEY_OPERATION = "containsKey";
    @Deprecated
    public static final String CONTAINS_VALUE_OPERATION = "containsValue";
    @Deprecated
    public static final String GET_KEYS_OPERATION = "keySet";
    @Deprecated
    public static final String REMOVEVALUE_OPERATION = "removevalue";
    @Deprecated
    public static final String INCREMENT_OPERATION = "increment";
    @Deprecated
    public static final String DECREMENT_OPERATION = "decrement";
    @Deprecated
    public static final String SETVALUE_OPERATION = "setvalue";
    @Deprecated
    public static final String DESTROY_OPERATION = "destroy";
    @Deprecated
    public static final String COMPARE_AND_SET_OPERATION = "compareAndSet";
    @Deprecated
    public static final String GET_AND_ADD_OPERATION = "getAndAdd";
    @Deprecated
    public static final String ADD_OPERATION = "add";
    @Deprecated
    public static final String OFFER_OPERATION = "offer";
    @Deprecated
    public static final String PEEK_OPERATION = "peek";
    @Deprecated
    public static final String POLL_OPERATION = "poll";
    @Deprecated
    public static final String REMAINING_CAPACITY_OPERATION = "remainingCapacity";
    @Deprecated
    public static final String DRAIN_TO_OPERATION = "drainTo";
    @Deprecated
    public static final String PUBLISH_OPERATION = "publish";
    @Deprecated
    public static final String READ_ONCE_HEAD_OPERATION = "readOnceHead";
    @Deprecated
    public static final String READ_ONCE_TAIL_OPERATION = "readOnceTail";
    @Deprecated
    public static final String GET_CAPACITY_OPERATION = "capacity";
    public static final String REMOVED = "removed";
    public static final String EVICTED = "evicted";
    public static final String EXPIRED = "expired";
    public static final String UPDATED = "updated";
    public static final String ADDED = "added";
    public static final String RECEIVED = "received";
    public static final String MAP = "map";
    public static final String MULTIMAP = "multimap";
    public static final String ATOMICNUMBER = "atomicnumber";
    public static final String QUEUE = "queue";
    public static final String CACHE_LISTENER = "cachelistener";
    public static final String INSTANCE_LISTENER = "instancelistener";
    public static final String ITEM_LISTENER = "itemlistener";
    public static final String OPERATION_PARAM = "operation";
    public static final String HAZELCAST_INSTANCE_NAME_PARAM = "hazelcastInstanceName";
    public static final String HAZELCAST_INSTANCE_PARAM = "hazelcastInstance";
    public static final String HAZELCAST_CONFIGU_PARAM = "hazelcastConfig";
    public static final String HAZELCAST_CONFIGU_URI_PARAM = "hazelcastConfigUri";
    public static final String HAZELCAST_NODE_MODE = "node";
    public static final String HAZELCAST_CLIENT_MODE = "client";

    private HazelcastConstants() {
    }
}

