/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.multimap;

import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.multimap.MultiMap;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelEntryListener;

public class HazelcastMultimapConsumer
extends HazelcastDefaultConsumer {
    private final MultiMap<Object, Object> cache;
    private UUID listener;

    public HazelcastMultimapConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.cache = hazelcastInstance.getMultiMap(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.cache.addEntryListener((EntryListener)new CamelEntryListener(this, this.cacheName), true);
    }

    protected void doStop() throws Exception {
        this.cache.removeEntryListener(this.listener);
        super.doStop();
    }
}

