/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.secret.manager;

import com.google.cloud.secretmanager.v1.AccessSecretVersionRequest;
import com.google.cloud.secretmanager.v1.AccessSecretVersionResponse;
import com.google.cloud.secretmanager.v1.AddSecretVersionRequest;
import com.google.cloud.secretmanager.v1.DeleteSecretRequest;
import com.google.cloud.secretmanager.v1.ListSecretsRequest;
import com.google.cloud.secretmanager.v1.ProjectName;
import com.google.cloud.secretmanager.v1.Replication;
import com.google.cloud.secretmanager.v1.Secret;
import com.google.cloud.secretmanager.v1.SecretManagerServiceClient;
import com.google.cloud.secretmanager.v1.SecretName;
import com.google.cloud.secretmanager.v1.SecretPayload;
import com.google.cloud.secretmanager.v1.SecretVersion;
import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.protobuf.ByteString;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerConfiguration;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerEndpoint;
import org.apache.camel.component.google.secret.manager.GoogleSecretManagerOperations;
import org.apache.camel.support.DefaultProducer;

public class GoogleSecretManagerProducer
extends DefaultProducer {
    private GoogleSecretManagerEndpoint endpoint;

    public GoogleSecretManagerProducer(GoogleSecretManagerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case createSecret: {
                this.createSecret(this.endpoint.getClient(), exchange);
                break;
            }
            case getSecretVersion: {
                this.getSecretVersion(this.endpoint.getClient(), exchange);
                break;
            }
            case deleteSecret: {
                this.deleteSecret(this.endpoint.getClient(), exchange);
                break;
            }
            case listSecrets: {
                this.listSecrets(this.endpoint.getClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void createSecret(SecretManagerServiceClient client, Exchange exchange) throws InvalidPayloadException {
        SecretVersion response = null;
        if (this.getConfiguration().isPojoRequest()) {
            AddSecretVersionRequest request = (AddSecretVersionRequest)exchange.getIn().getMandatoryBody(AddSecretVersionRequest.class);
            response = client.addSecretVersion(request);
        } else {
            String secretId = (String)exchange.getMessage().getHeader("CamelGoogleSecretManagerSecretId", String.class);
            Secret secret = Secret.newBuilder().setReplication(Replication.newBuilder().setAutomatic(Replication.Automatic.newBuilder().build()).build()).build();
            Secret createdSecret = client.createSecret(ProjectName.of((String)this.getConfiguration().getProject()), secretId, secret);
            SecretPayload payload = SecretPayload.newBuilder().setData(ByteString.copyFromUtf8((String)((String)exchange.getMessage().getBody(String.class)))).build();
            response = client.addSecretVersion(createdSecret.getName(), payload);
        }
        Message message = GoogleSecretManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private void getSecretVersion(SecretManagerServiceClient client, Exchange exchange) throws InvalidPayloadException {
        AccessSecretVersionResponse response;
        String defaultVersion = "latest";
        if (this.getConfiguration().isPojoRequest()) {
            AccessSecretVersionRequest request = (AccessSecretVersionRequest)exchange.getIn().getMandatoryBody(AccessSecretVersionRequest.class);
            response = client.accessSecretVersion(request);
        } else {
            String secretId = (String)exchange.getMessage().getHeader("CamelGoogleSecretManagerSecretId", String.class);
            String versionId = (String)exchange.getMessage().getHeader("CamelGoogleSecretManagerVersionId", (Object)"latest", String.class);
            String projectId = this.getConfiguration().getProject();
            SecretVersionName secretVersionName = SecretVersionName.of((String)projectId, (String)secretId, (String)versionId);
            response = client.accessSecretVersion(secretVersionName);
        }
        Message message = GoogleSecretManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)response.getPayload().getData().toStringUtf8());
    }

    private void deleteSecret(SecretManagerServiceClient client, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            DeleteSecretRequest request = (DeleteSecretRequest)exchange.getIn().getMandatoryBody(DeleteSecretRequest.class);
            client.deleteSecret(request);
        } else {
            String secretId = (String)exchange.getMessage().getHeader("CamelGoogleSecretManagerSecretId", String.class);
            client.deleteSecret(SecretName.of((String)this.getConfiguration().getProject(), (String)secretId));
        }
    }

    private void listSecrets(SecretManagerServiceClient client, Exchange exchange) throws InvalidPayloadException {
        SecretManagerServiceClient.ListSecretsPagedResponse response;
        if (this.getConfiguration().isPojoRequest()) {
            ListSecretsRequest request = (ListSecretsRequest)exchange.getIn().getMandatoryBody(ListSecretsRequest.class);
            response = client.listSecrets(request);
        } else {
            String projectId = this.getConfiguration().getProject();
            response = client.listSecrets(ProjectName.of((String)projectId));
        }
        Message message = GoogleSecretManagerProducer.getMessageForResponse(exchange);
        message.setBody((Object)response);
    }

    private GoogleSecretManagerOperations determineOperation(Exchange exchange) {
        GoogleSecretManagerOperations operation = (GoogleSecretManagerOperations)((Object)exchange.getIn().getHeader("GoogleSecretManagerOperation", GoogleSecretManagerOperations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation() == null ? GoogleSecretManagerOperations.createSecret : this.getConfiguration().getOperation();
        }
        return operation;
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    private GoogleSecretManagerConfiguration getConfiguration() {
        return this.endpoint.getConfiguration();
    }
}

