/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.Comment;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.service.GitHubService;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.PullRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullRequestCommentConsumer
extends AbstractGitHubConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(PullRequestCommentConsumer.class);
    private PullRequestService pullRequestService;
    private IssueService issueService;
    private List<Long> commentIds = new ArrayList<Long>();

    public PullRequestCommentConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object service = registry.lookupByName("githubPullRequestService");
        if (service != null) {
            LOG.debug("Using PullRequestService found in registry {}", (Object)service.getClass().getCanonicalName());
            this.pullRequestService = (PullRequestService)service;
        } else {
            this.pullRequestService = new PullRequestService();
        }
        this.initService((GitHubService)this.pullRequestService);
        service = registry.lookupByName("githbIssueService");
        this.issueService = service != null ? (IssueService)service : new IssueService();
        this.initService((GitHubService)this.issueService);
        LOG.info("GitHub PullRequestCommentConsumer: Indexing current pull request comments...");
        List pullRequests = this.pullRequestService.getPullRequests((IRepositoryIdProvider)this.getRepository(), "open");
        for (PullRequest pullRequest : pullRequests) {
            List commitComments = this.pullRequestService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : commitComments) {
                this.commentIds.add(comment.getId());
            }
            List comments = this.issueService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : comments) {
                this.commentIds.add(comment.getId());
            }
        }
    }

    protected int poll() throws Exception {
        HashMap<Long, PullRequest> commentIdToPullRequest = new HashMap<Long, PullRequest>();
        List pullRequests = this.pullRequestService.getPullRequests((IRepositoryIdProvider)this.getRepository(), "open");
        ArrayDeque<Comment> newComments = new ArrayDeque<Comment>();
        for (PullRequest pullRequest : pullRequests) {
            List commitComments = this.pullRequestService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : commitComments) {
                if (this.commentIds.contains(comment.getId())) continue;
                newComments.add(comment);
                this.commentIds.add(comment.getId());
                commentIdToPullRequest.put(comment.getId(), pullRequest);
            }
            List comments = this.issueService.getComments((IRepositoryIdProvider)this.getRepository(), pullRequest.getNumber());
            for (Comment comment : comments) {
                if (this.commentIds.contains(comment.getId())) continue;
                newComments.add(comment);
                this.commentIds.add(comment.getId());
                commentIdToPullRequest.put(comment.getId(), pullRequest);
            }
        }
        ArrayDeque<Object> exchanges = new ArrayDeque<Object>();
        while (!newComments.isEmpty()) {
            Comment newComment = (Comment)newComments.pop();
            Exchange e = this.createExchange(true);
            e.getIn().setBody((Object)newComment);
            e.getIn().setHeader("GitHubPullRequest", commentIdToPullRequest.get(newComment.getId()));
            exchanges.add(e);
        }
        return this.processBatch(exchanges);
    }
}

