/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.github.consumer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.github.GitHubEndpoint;
import org.apache.camel.component.github.consumer.AbstractGitHubConsumer;
import org.apache.camel.component.github.event.GitHubEventFetchStrategy;
import org.apache.camel.spi.Registry;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.service.EventService;
import org.eclipse.egit.github.core.service.GitHubService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsConsumer
extends AbstractGitHubConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(EventsConsumer.class);
    private final EventService eventService;
    private final GitHubEventFetchStrategy eventFetchStrategy;
    private long lastEventId;

    public EventsConsumer(GitHubEndpoint endpoint, Processor processor) throws Exception {
        super(endpoint, processor);
        Registry registry = endpoint.getCamelContext().getRegistry();
        EventService service = (EventService)registry.lookupByNameAndType("GitHubEventService", EventService.class);
        this.eventService = service != null ? service : new EventService();
        this.initService((GitHubService)this.eventService);
        GitHubEventFetchStrategy strategy = endpoint.getEventFetchStrategy();
        this.eventFetchStrategy = strategy != null ? strategy : new DefaultGitHubEventFetchStrategy(this.getRepository());
    }

    protected int poll() throws Exception {
        ArrayList<Event> newEvents = new ArrayList<Event>();
        PageIterator<Event> iterator = this.eventFetchStrategy.fetchEvents(this.eventService);
        while (iterator.hasNext()) {
            Collection events = iterator.next();
            for (Event event : events) {
                if (Long.parseLong(event.getId()) <= this.lastEventId) continue;
                newEvents.add(event);
            }
        }
        ArrayDeque<Object> exchanges = new ArrayDeque<Object>();
        if (!newEvents.isEmpty()) {
            newEvents.sort((e1, e2) -> Long.valueOf(e1.getId()).compareTo(Long.parseLong(e2.getId())));
            Event latestEvent = (Event)newEvents.get(newEvents.size() - 1);
            this.lastEventId = Long.parseLong(latestEvent.getId());
            for (Event event : newEvents) {
                Exchange e = this.createExchange(true);
                e.getMessage().setBody((Object)event.getType());
                e.getMessage().setHeader("CamelGitHubEventPayload", (Object)event.getPayload());
                exchanges.add(e);
            }
        }
        return this.processBatch(exchanges);
    }

    private static final class DefaultGitHubEventFetchStrategy
    implements GitHubEventFetchStrategy {
        private final Repository repository;

        private DefaultGitHubEventFetchStrategy(Repository repository) {
            this.repository = repository;
        }

        @Override
        public PageIterator<Event> fetchEvents(EventService eventService) {
            return eventService.pageEvents((IRepositoryIdProvider)this.repository);
        }
    }
}

