/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.rest.api.SearchStyleEnum;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@ApiParams(apiName="search", description="API to search for resources matching a given set of criteria", apiMethods={@ApiMethod(methodName="searchByResource", description="Perform a search by resource name", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle searchByResource(String resourceName, java.util.Map<String, java.util.List<String>> searchParameters, ca.uhn.fhir.rest.api.SearchStyleEnum searchStyle, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="searchByUrl", description="Perform a search directly by URL", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle searchByUrl(String url, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer(extended=true)
public final class FhirSearchEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="searchByResource", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="searchByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="searchByResource", description="The resource to search for")})
    private String resourceName;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="searchByResource", description="A set of search parameters to the query")})
    private Map<String, List<String>> searchParameters;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="searchByResource", description="Forces the query to perform the search using the given method (allowable methods are described in the FHIR Search Specification). The default search style is HTTP POST.")})
    private SearchStyleEnum searchStyle;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="searchByUrl", description="The URL to search for. Note that this URL may be complete (e.g. http://example.com/base/Patientname=foo) in which case the client's base URL will be ignored. Or it can be relative (e.g. Patientname=foo) in which case the client's base URL will be used.")})
    private String url;

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Map<String, List<String>> getSearchParameters() {
        return this.searchParameters;
    }

    public void setSearchParameters(Map<String, List<String>> searchParameters) {
        this.searchParameters = searchParameters;
    }

    public SearchStyleEnum getSearchStyle() {
        return this.searchStyle;
    }

    public void setSearchStyle(SearchStyleEnum searchStyle) {
        this.searchStyle = searchStyle;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

