/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.rest.client;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.elasticsearch.rest.client.ElasticSearchRestClientConstant;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientComponent;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientOperation;
import org.apache.camel.component.elasticsearch.rest.client.ElasticsearchRestClientProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.elasticsearch.client.RestClient;

@UriEndpoint(firstVersion="4.3.0", scheme="elasticsearch-rest-client", title="Elasticsearch Low level Rest Client", syntax="elasticsearch-rest-client:clusterName", producerOnly=true, category={Category.SEARCH}, headersClass=ElasticSearchRestClientConstant.class)
public class ElasticsearchRestClientEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    @UriPath
    @Metadata(required=true)
    private String clusterName;
    @UriParam
    @Metadata(required=true)
    ElasticsearchRestClientOperation operation;
    @UriParam(label="advanced")
    @Metadata(autowired=true)
    RestClient restClient;
    @UriParam
    String indexName;
    @UriParam
    String hostAddressesList;
    @UriParam(defaultValue="30000")
    private int connectionTimeout = 30000;
    @UriParam(defaultValue="30000")
    private int socketTimeout = 30000;
    @UriParam(label="security", secret=true)
    private String user;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="security")
    @Metadata(supportFileReference=true)
    private String certificatePath;
    @UriParam(label="advanced")
    private boolean enableSniffer;
    @UriParam(label="advanced", defaultValue="60000")
    private int snifferInterval = 60000;
    @UriParam(label="advanced", defaultValue="60000")
    private int sniffAfterFailureDelay = 60000;

    public ElasticsearchRestClientEndpoint(String uri, ElasticsearchRestClientComponent component) {
        super(uri, (Component)component);
    }

    public void doInit() throws Exception {
        super.doInit();
        ObjectHelper.notNull((Object)((Object)this.operation), (String)"operation");
    }

    public Producer createProducer() throws Exception {
        return new ElasticsearchRestClientProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from an ElasticsearchEndpoint: " + this.getEndpointUri());
    }

    public String getServiceUrl() {
        return this.getHostAddressesList();
    }

    public String getServiceProtocol() {
        return "elasticsearch";
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public ElasticsearchRestClientOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ElasticsearchRestClientOperation operation) {
        this.operation = operation;
    }

    public RestClient getRestClient() {
        return this.restClient;
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getHostAddressesList() {
        return this.hostAddressesList;
    }

    public void setHostAddressesList(String hostAddressesList) {
        this.hostAddressesList = hostAddressesList;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public boolean isEnableSniffer() {
        return this.enableSniffer;
    }

    public void setEnableSniffer(boolean enableSniffer) {
        this.enableSniffer = enableSniffer;
    }

    public int getSnifferInterval() {
        return this.snifferInterval;
    }

    public void setSnifferInterval(int snifferInterval) {
        this.snifferInterval = snifferInterval;
    }

    public int getSniffAfterFailureDelay() {
        return this.sniffAfterFailureDelay;
    }

    public void setSniffAfterFailureDelay(int sniffAfterFailureDelay) {
        this.sniffAfterFailureDelay = sniffAfterFailureDelay;
    }
}

