/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.DictColumnMetadata;
import org.apache.drill.exec.record.metadata.MetadataUtils;
import org.apache.drill.exec.record.metadata.PrimitiveColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;

public class SchemaPathUtils {
    private SchemaPathUtils() {
    }

    public static ColumnMetadata getColumnMetadata(SchemaPath schemaPath, TupleMetadata schema) {
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ColumnMetadata colMetadata = schema.metadata(colPath.getPath());
        while (!colPath.isLastPath() && colMetadata != null) {
            if (colMetadata.isDict()) {
                colMetadata = ((DictColumnMetadata)colMetadata).valueColumnMetadata();
                break;
            }
            if (!colMetadata.isMap()) {
                colMetadata = null;
                break;
            }
            colPath = (PathSegment.NameSegment)colPath.getChild();
            colMetadata = colMetadata.tupleSchema().metadata(colPath.getPath());
        }
        return colMetadata;
    }

    public static boolean isFieldNestedInDictOrRepeatedMap(SchemaPath schemaPath, TupleMetadata schema) {
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ColumnMetadata colMetadata = schema.metadata(colPath.getPath());
        while (!colPath.isLastPath() && colMetadata != null) {
            if (colMetadata.isDict() || colMetadata.isMap() && Types.isRepeated(colMetadata.majorType())) {
                return true;
            }
            if (!colMetadata.isMap()) break;
            colPath = (PathSegment.NameSegment)colPath.getChild();
            colMetadata = colMetadata.tupleSchema().metadata(colPath.getPath());
        }
        return false;
    }

    public static void addColumnMetadata(TupleMetadata schema, SchemaPath schemaPath, TypeProtos.MajorType type, Map<SchemaPath, TypeProtos.MajorType> types) {
        ColumnMetadata colMetadata;
        PathSegment.NameSegment colPath = schemaPath.getUnIndexed().getRootSegment();
        ArrayList<String> names = new ArrayList<String>(types.size());
        ArrayList<String> nextNames = new ArrayList<String>(names.size());
        while (!colPath.isLastPath()) {
            names.add(colPath.getPath());
            colMetadata = schema.metadata(colPath.getPath());
            TypeProtos.MajorType pathType = types.get(SchemaPath.getCompoundPath(names.toArray(new String[0])));
            boolean isDict = pathType != null && pathType.getMinorType() == TypeProtos.MinorType.DICT;
            boolean isList = pathType != null && pathType.getMinorType() == TypeProtos.MinorType.LIST;
            String name = colPath.getPath();
            if (isList) {
                nextNames.clear();
                nextNames.addAll(names);
                PathSegment.NameSegment bagSegment = colPath.getChild().getNameSegment();
                PathSegment.NameSegment elementSegment = bagSegment.getChild().getNameSegment();
                nextNames.add(bagSegment.getPath());
                nextNames.add(elementSegment.getPath());
                pathType = types.get(SchemaPath.getCompoundPath(nextNames.toArray(new String[0])));
                if (pathType == null && colPath.getChild().getChild().isLastPath()) break;
                colPath = elementSegment;
                names.add(bagSegment.getPath());
                names.add(elementSegment.getPath());
                boolean bl = isDict = pathType != null && pathType.getMinorType() == TypeProtos.MinorType.DICT;
            }
            if (colMetadata == null) {
                colMetadata = isDict ? (isList ? MetadataUtils.newDictArray(name) : MetadataUtils.newDict(name)) : (isList ? MetadataUtils.newMapArray(name, null) : MetadataUtils.newMap(name, null));
                schema.addColumn(colMetadata);
            }
            if (isDict) {
                colPath = (PathSegment.NameSegment)colPath.getChild();
                names.add(colPath.getPath());
            }
            if (!colMetadata.isMap() && !colMetadata.isDict()) {
                throw new DrillRuntimeException(String.format("Expected map or dict, but was %s", colMetadata.majorType()));
            }
            schema = colMetadata.tupleSchema();
            colPath = (PathSegment.NameSegment)colPath.getChild();
        }
        if ((colMetadata = schema.metadata(colPath.getPath())) == null) {
            schema.addColumn(new PrimitiveColumnMetadata(MaterializedField.create(colPath.getPath(), type)));
        } else if (!colMetadata.majorType().equals(type)) {
            throw new DrillRuntimeException(String.format("Types mismatch: existing type: %s, new type: %s", colMetadata.majorType(), type));
        }
    }
}

