/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.statistics;

import java.util.Collection;
import org.apache.drill.metastore.metadata.Metadata;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.statistics.BaseStatisticsKind;
import org.apache.drill.metastore.statistics.CollectableTableStatisticsKind;

public class TableStatisticsKind<T>
extends BaseStatisticsKind<T>
implements CollectableTableStatisticsKind<T> {
    public static final TableStatisticsKind<Long> ROW_COUNT = new TableStatisticsKind<Long>("rowCount", true){

        @Override
        public Long mergeStatistics(Collection<? extends Metadata> statistics) {
            long rowCount = 0L;
            for (Metadata metadata : statistics) {
                Long statRowCount = this.getValue(metadata);
                if (statRowCount == -1L) {
                    rowCount = -1L;
                    break;
                }
                rowCount += statRowCount.longValue();
            }
            return rowCount;
        }

        @Override
        public Long getValue(Metadata metadata) {
            Long rowCount = (Long)super.getValue(metadata);
            return rowCount != null ? rowCount : -1L;
        }
    };
    public static final TableStatisticsKind<Double> EST_ROW_COUNT = new TableStatisticsKind<Double>("rowcount", false){

        @Override
        public Double mergeStatistics(Collection<? extends Metadata> statisticsList) {
            double rowCount = 0.0;
            for (Metadata metadata : statisticsList) {
                Double statRowCount = (Double)this.getValue(metadata);
                if (statRowCount == null) continue;
                rowCount += statRowCount.doubleValue();
            }
            return rowCount;
        }
    };
    public static final TableStatisticsKind<Boolean> HAS_DESCRIPTIVE_STATISTICS = new TableStatisticsKind<Boolean>("hasDescriptiveStatistics", false){

        @Override
        public Boolean mergeStatistics(Collection<? extends Metadata> statisticsList) {
            for (Metadata metadata : statisticsList) {
                Boolean hasDescriptiveStatistics = metadata.getStatistic(this);
                if (hasDescriptiveStatistics != null && hasDescriptiveStatistics.booleanValue()) continue;
                return false;
            }
            return Boolean.TRUE;
        }

        @Override
        public Boolean getValue(Metadata metadata) {
            return Boolean.TRUE.equals(metadata.getStatistic(this));
        }
    };
    public static final TableStatisticsKind<MetadataType> ANALYZE_METADATA_LEVEL = new TableStatisticsKind<MetadataType>("analyzeMetadataLevel", false){

        @Override
        public MetadataType mergeStatistics(Collection<? extends Metadata> statisticsList) {
            MetadataType maxMetadataType = MetadataType.ALL;
            for (Metadata metadata : statisticsList) {
                MetadataType metadataType = metadata.getStatistic(this);
                if (metadataType == null || metadataType.compareTo(maxMetadataType) >= 0) continue;
                maxMetadataType = metadataType;
            }
            return maxMetadataType;
        }

        @Override
        public MetadataType getValue(Metadata metadata) {
            return metadata.getStatistic(this);
        }
    };

    public TableStatisticsKind(String statisticKey, boolean exact) {
        super(statisticKey, exact);
    }

    @Override
    public T mergeStatistics(Collection<? extends Metadata> statistics) {
        throw new UnsupportedOperationException("Cannot merge statistics for " + this.statisticKey);
    }

    public T getValue(Metadata metadata) {
        return (T)metadata.getStatistic(this);
    }
}

