/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.metadata;

import java.util.Objects;
import java.util.StringJoiner;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.metadata.BaseMetadata;
import org.apache.drill.metastore.metadata.LocationProvider;
import org.apache.hadoop.fs.Path;

public class FileMetadata
extends BaseMetadata
implements LocationProvider {
    private final Path path;

    private FileMetadata(FileMetadataBuilder builder) {
        super(builder);
        this.path = builder.path;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Path getLocation() {
        return this.path.getParent();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileMetadata that = (FileMetadata)o;
        return Objects.equals(this.path, that.path);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    public String toString() {
        return new StringJoiner(",\n", FileMetadata.class.getSimpleName() + "[\n", "]").add("path=" + this.path).add("tableInfo=" + this.tableInfo).add("metadataInfo=" + this.metadataInfo).add("schema=" + this.schema).add("columnsStatistics=" + this.columnsStatistics).add("metadataStatistics=" + this.metadataStatistics).add("lastModifiedTime=" + this.lastModifiedTime).toString();
    }

    @Override
    protected void toMetadataUnitBuilder(TableMetadataUnit.Builder builder) {
        builder.path(this.path.toUri().getPath());
        builder.location(this.getLocation().toUri().getPath());
    }

    public FileMetadataBuilder toBuilder() {
        return ((FileMetadataBuilder)((FileMetadataBuilder)((FileMetadataBuilder)((FileMetadataBuilder)((FileMetadataBuilder)((FileMetadataBuilder)FileMetadata.builder().tableInfo(this.tableInfo)).metadataInfo(this.metadataInfo)).schema(this.schema)).columnsStatistics(this.columnsStatistics)).metadataStatistics(this.metadataStatistics.values())).lastModifiedTime(this.lastModifiedTime)).path(this.path);
    }

    public static FileMetadataBuilder builder() {
        return new FileMetadataBuilder();
    }

    public static class FileMetadataBuilder
    extends BaseMetadata.BaseMetadataBuilder<FileMetadataBuilder> {
        private Path path;

        public FileMetadataBuilder path(Path path) {
            this.path = path;
            return this.self();
        }

        @Override
        protected void checkRequiredValues() {
            super.checkRequiredValues();
            Objects.requireNonNull(this.path, "path was not set");
        }

        @Override
        public FileMetadata build() {
            this.checkRequiredValues();
            return new FileMetadata(this);
        }

        @Override
        protected FileMetadataBuilder self() {
            return this;
        }

        @Override
        protected FileMetadataBuilder metadataUnitInternal(TableMetadataUnit unit) {
            if (unit.path() != null) {
                this.path(new Path(unit.path()));
            }
            return this.self();
        }
    }
}

