/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore.components.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.drill.metastore.MetastoreColumn;
import org.apache.drill.metastore.components.tables.BasicTablesTransformer;
import org.apache.drill.metastore.components.tables.MetastoreTableInfo;
import org.apache.drill.metastore.components.tables.TableMetadataUnit;
import org.apache.drill.metastore.components.tables.Tables;
import org.apache.drill.metastore.expressions.FilterExpression;
import org.apache.drill.metastore.metadata.BaseTableMetadata;
import org.apache.drill.metastore.metadata.FileMetadata;
import org.apache.drill.metastore.metadata.MetadataInfo;
import org.apache.drill.metastore.metadata.MetadataType;
import org.apache.drill.metastore.metadata.PartitionMetadata;
import org.apache.drill.metastore.metadata.RowGroupMetadata;
import org.apache.drill.metastore.metadata.SegmentMetadata;
import org.apache.drill.metastore.metadata.TableInfo;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;

public class BasicTablesRequests {
    private final Tables tables;

    public BasicTablesRequests(Tables tables) {
        this.tables = tables;
    }

    public MetastoreTableInfo metastoreTableInfo(TableInfo tableInfo) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey("GENERAL_INFO").metadataType(MetadataType.TABLE).requestColumns(MetastoreColumn.LAST_MODIFIED_TIME).build();
        long version = this.tables.metadata().version();
        TableMetadataUnit unit = this.retrieveSingleElement(this.request(requestMetadata));
        return MetastoreTableInfo.of(tableInfo, unit, version);
    }

    public boolean hasMetastoreTableInfoChanged(MetastoreTableInfo metastoreTableInfo) {
        if (this.tables.metadata().supportsVersioning() && metastoreTableInfo.metastoreVersion() == this.tables.metadata().version()) {
            return false;
        }
        MetastoreTableInfo current = this.metastoreTableInfo(metastoreTableInfo.tableInfo());
        return metastoreTableInfo.hasChanged(current.isExists(), current.lastModifiedTime());
    }

    public List<BaseTableMetadata> tablesMetadata(FilterExpression filter) {
        RequestMetadata requestMetadata = RequestMetadata.builder().customFilter(filter).metadataKey("GENERAL_INFO").metadataType(MetadataType.TABLE).requestColumns(TableMetadataUnit.SCHEMA.tableColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.tables(units);
    }

    public BaseTableMetadata tableMetadata(TableInfo tableInfo) {
        List<BaseTableMetadata> tables = this.tablesMetadata(tableInfo.toFilter());
        return this.retrieveSingleElement(tables);
    }

    public List<SegmentMetadata> segmentsMetadataByMetadataKey(TableInfo tableInfo, List<String> locations, String metadataKey) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).locations(locations).metadataKey(metadataKey).metadataType(MetadataType.SEGMENT).requestColumns(TableMetadataUnit.SCHEMA.segmentColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.segments(units);
    }

    public List<SegmentMetadata> segmentsMetadataByColumn(TableInfo tableInfo, List<String> locations, String column) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).locations(locations).column(column).metadataType(MetadataType.SEGMENT).requestColumns(TableMetadataUnit.SCHEMA.segmentColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.segments(units);
    }

    public List<SegmentMetadata> segmentsMetadata(TableInfo tableInfo, List<MetadataInfo> metadataInfos) {
        List<String> keys = metadataInfos.stream().map(MetadataInfo::key).collect(Collectors.toList());
        List<String> identifiers = metadataInfos.stream().map(MetadataInfo::identifier).collect(Collectors.toList());
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(keys).identifiers(identifiers).metadataType(MetadataType.SEGMENT).requestColumns(TableMetadataUnit.SCHEMA.segmentColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.segments(units);
    }

    public List<TableMetadataUnit> metadata(TableInfo tableInfo, Collection<MetadataInfo> metadataInfos) {
        List<String> keys = metadataInfos.stream().map(MetadataInfo::key).collect(Collectors.toList());
        List<String> identifiers = metadataInfos.stream().map(MetadataInfo::identifier).collect(Collectors.toList());
        Set<MetadataType> metadataTypes = metadataInfos.stream().map(MetadataInfo::type).collect(Collectors.toSet());
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(keys).identifiers(identifiers).metadataTypes(metadataTypes).build();
        return this.request(requestMetadata);
    }

    public List<PartitionMetadata> partitionsMetadata(TableInfo tableInfo, List<String> metadataKeys, String column) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(metadataKeys).column(column).metadataType(MetadataType.PARTITION).requestColumns(TableMetadataUnit.SCHEMA.partitionColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.partitions(units);
    }

    public List<FileMetadata> filesMetadata(TableInfo tableInfo, String metadataKey, List<String> paths) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey(metadataKey).paths(paths).metadataType(MetadataType.FILE).requestColumns(TableMetadataUnit.SCHEMA.fileColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.files(units);
    }

    public List<FileMetadata> filesMetadata(TableInfo tableInfo, List<MetadataInfo> metadataInfos) {
        List<String> keys = metadataInfos.stream().map(MetadataInfo::key).collect(Collectors.toList());
        List<String> identifiers = metadataInfos.stream().map(MetadataInfo::identifier).collect(Collectors.toList());
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(keys).identifiers(identifiers).metadataType(MetadataType.FILE).requestColumns(TableMetadataUnit.SCHEMA.fileColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.files(units);
    }

    public FileMetadata fileMetadata(TableInfo tableInfo, String metadataKey, String path) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey(metadataKey).path(path).metadataType(MetadataType.FILE).requestColumns(TableMetadataUnit.SCHEMA.fileColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return this.retrieveSingleElement(BasicTablesTransformer.files(units));
    }

    public List<RowGroupMetadata> rowGroupsMetadata(TableInfo tableInfo, String metadataKey, String path) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey(metadataKey).path(path).metadataType(MetadataType.ROW_GROUP).requestColumns(TableMetadataUnit.SCHEMA.rowGroupColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.rowGroups(units);
    }

    public List<RowGroupMetadata> rowGroupsMetadata(TableInfo tableInfo, List<String> metadataKeys, List<String> paths) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(metadataKeys).paths(paths).metadataType(MetadataType.ROW_GROUP).requestColumns(TableMetadataUnit.SCHEMA.rowGroupColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.rowGroups(units);
    }

    public List<RowGroupMetadata> rowGroupsMetadata(TableInfo tableInfo, List<MetadataInfo> metadataInfos) {
        List<String> keys = metadataInfos.stream().map(MetadataInfo::key).collect(Collectors.toList());
        List<String> identifiers = metadataInfos.stream().map(MetadataInfo::identifier).collect(Collectors.toList());
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(keys).identifiers(identifiers).metadataType(MetadataType.ROW_GROUP).requestColumns(TableMetadataUnit.SCHEMA.rowGroupColumns()).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.rowGroups(units);
    }

    public BasicTablesTransformer.MetadataHolder fullSegmentsMetadataWithoutPartitions(TableInfo tableInfo, List<String> metadataKeys, List<String> locations) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKeys(metadataKeys).locations(locations).metadataTypes(MetadataType.SEGMENT, MetadataType.FILE, MetadataType.ROW_GROUP).build();
        List<TableMetadataUnit> units = this.request(requestMetadata);
        return BasicTablesTransformer.all(units);
    }

    public Map<String, Long> filesLastModifiedTime(TableInfo tableInfo, String metadataKey, List<String> locations) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey(metadataKey).locations(locations).metadataType(MetadataType.FILE).requestColumns(MetastoreColumn.PATH, MetastoreColumn.LAST_MODIFIED_TIME).build();
        return this.request(requestMetadata).stream().collect(Collectors.toMap(TableMetadataUnit::path, TableMetadataUnit::lastModifiedTime, (o, n) -> n));
    }

    public Map<String, Long> segmentsLastModifiedTime(TableInfo tableInfo, List<String> locations) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).locations(locations).metadataType(MetadataType.SEGMENT).requestColumns(MetastoreColumn.METADATA_KEY, MetastoreColumn.LAST_MODIFIED_TIME).build();
        return this.request(requestMetadata).stream().collect(Collectors.toMap(TableMetadataUnit::metadataKey, TableMetadataUnit::lastModifiedTime, (o, n) -> n));
    }

    public TableMetadataUnit interestingColumnsAndPartitionKeys(TableInfo tableInfo) {
        RequestMetadata requestMetadata = RequestMetadata.builder().tableInfo(tableInfo).metadataKey("GENERAL_INFO").metadataType(MetadataType.TABLE).requestColumns(MetastoreColumn.INTERESTING_COLUMNS, MetastoreColumn.PARTITION_KEYS).build();
        return this.retrieveSingleElement(this.request(requestMetadata));
    }

    public List<TableMetadataUnit> request(RequestMetadata requestMetadata) {
        return this.tables.read().metadataTypes(requestMetadata.metadataTypes()).filter(requestMetadata.filter()).columns(requestMetadata.columns()).execute();
    }

    private <T> T retrieveSingleElement(List<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        if (elements.size() > 1) {
            throw new IllegalArgumentException(String.format("Expected one element but received [%s]", elements.size()));
        }
        return elements.get(0);
    }

    public static class RequestMetadata {
        private Set<MetadataType> metadataTypes;
        private final FilterExpression filter;
        private final List<MetastoreColumn> columns;

        private RequestMetadata(Set<MetadataType> metadataTypes, FilterExpression filter, List<MetastoreColumn> columns) {
            this.metadataTypes = metadataTypes;
            this.filter = filter;
            this.columns = columns;
        }

        public Set<MetadataType> metadataTypes() {
            return this.metadataTypes;
        }

        public FilterExpression filter() {
            return this.filter;
        }

        public List<MetastoreColumn> columns() {
            return this.columns;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private TableInfo tableInfo;
            private String location;
            private List<String> locations;
            private String column;
            private String metadataKey;
            private List<String> metadataKeys;
            private String path;
            private List<String> paths;
            private List<String> identifiers;
            private FilterExpression customFilter;
            private Set<MetadataType> metadataTypes = new HashSet<MetadataType>();
            private final List<MetastoreColumn> requestColumns = new ArrayList<MetastoreColumn>();

            public Builder metadataType(MetadataType metadataType) {
                this.metadataTypes.add(metadataType);
                return this;
            }

            public Builder metadataTypes(MetadataType ... metadataTypes) {
                this.metadataTypes.addAll(Sets.newHashSet(metadataTypes));
                return this;
            }

            public Builder metadataTypes(Set<MetadataType> metadataTypes) {
                this.metadataTypes.addAll(metadataTypes);
                return this;
            }

            public Builder tableInfo(TableInfo tableInfo) {
                this.tableInfo = tableInfo;
                return this;
            }

            public Builder location(String location) {
                this.location = location;
                return this;
            }

            public Builder locations(List<String> locations) {
                this.locations = locations;
                return this;
            }

            public Builder column(String column) {
                this.column = column;
                return this;
            }

            public Builder metadataKey(String metadataKey) {
                this.metadataKey = metadataKey;
                return this;
            }

            public Builder metadataKeys(List<String> metadataKeys) {
                this.metadataKeys = metadataKeys;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder paths(List<String> paths) {
                this.paths = paths;
                return this;
            }

            public Builder identifiers(List<String> identifiers) {
                this.identifiers = identifiers;
                return this;
            }

            public Builder customFilter(FilterExpression customFilter) {
                this.customFilter = customFilter;
                return this;
            }

            public Builder requestColumns(List<MetastoreColumn> requestColumns) {
                this.requestColumns.addAll(requestColumns);
                return this;
            }

            public Builder requestColumns(MetastoreColumn ... requestColumns) {
                return this.requestColumns(Arrays.asList(requestColumns));
            }

            public RequestMetadata build() {
                return new RequestMetadata(this.metadataTypes, this.createFilter(), this.requestColumns);
            }

            private FilterExpression createFilter() {
                ArrayList<FilterExpression> filters = new ArrayList<FilterExpression>();
                if (this.tableInfo != null) {
                    filters.add(this.tableInfo.toFilter());
                }
                this.addFilter(MetastoreColumn.LOCATION, this.location, filters);
                this.addFilter(MetastoreColumn.LOCATION, this.locations, filters);
                this.addFilter(MetastoreColumn.COLUMN, this.column, filters);
                this.addFilter(MetastoreColumn.METADATA_KEY, this.metadataKey, filters);
                this.addFilter(MetastoreColumn.METADATA_KEY, this.metadataKeys, filters);
                this.addFilter(MetastoreColumn.PATH, this.path, filters);
                this.addFilter(MetastoreColumn.PATH, this.paths, filters);
                this.addFilter(MetastoreColumn.METADATA_IDENTIFIER, this.identifiers, filters);
                if (this.customFilter != null) {
                    filters.add(this.customFilter);
                }
                if (filters.isEmpty()) {
                    return null;
                }
                if (filters.size() == 1) {
                    return (FilterExpression)filters.get(0);
                }
                return FilterExpression.and((FilterExpression)filters.get(0), (FilterExpression)filters.get(1), filters.subList(2, filters.size()).toArray(new FilterExpression[0]));
            }

            private <T> void addFilter(MetastoreColumn column, T value, List<FilterExpression> filters) {
                if (value == null) {
                    return;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    if (list.isEmpty()) {
                        return;
                    }
                    filters.add(FilterExpression.in(column, list));
                    return;
                }
                filters.add(FilterExpression.equal(column, value));
            }
        }
    }
}

