/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.metastore;

import com.typesafe.config.ConfigMergeable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.metastore.Metastore;
import org.apache.drill.metastore.config.MetastoreConfigFileInfo;
import org.apache.drill.metastore.exceptions.MetastoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreRegistry
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreRegistry.class);
    private final DrillConfig config;
    private final boolean useProvided;
    private volatile Metastore metastore;

    public MetastoreRegistry(DrillConfig config) {
        this.config = config;
        this.useProvided = config.hasPath("drill.metastore.config.use_provided") && config.getBoolean("drill.metastore.config.use_provided");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metastore get() {
        if (this.metastore == null) {
            MetastoreRegistry metastoreRegistry = this;
            synchronized (metastoreRegistry) {
                if (this.metastore == null) {
                    this.metastore = this.initMetastore();
                }
            }
        }
        return this.metastore;
    }

    private Metastore initMetastore() {
        Object instance;
        MethodHandle constructor;
        DrillConfig metastoreConfig = this.useProvided ? this.config : this.createMetastoreConfig(this.config);
        String metastoreClass = metastoreConfig.getString("drill.metastore.implementation.class");
        if (metastoreClass == null) {
            throw new MetastoreException(String.format("Drill Metastore class config is absent [%s]", "drill.metastore.implementation.class"));
        }
        MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
        try {
            MethodType methodType = MethodType.methodType(Void.TYPE, DrillConfig.class);
            constructor = publicLookup.findConstructor(Class.forName(metastoreClass), methodType);
        }
        catch (ClassNotFoundException e) {
            throw new MetastoreException(String.format("Unable to find Metastore implementation class [%s]", metastoreClass));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new MetastoreException(String.format("Metastore implementation class [%s] must have constructor which accepts [%s]", metastoreClass, metastoreConfig.getClass().getSimpleName()));
        }
        try {
            instance = constructor.invokeWithArguments(metastoreConfig);
        }
        catch (Throwable e) {
            throw new MetastoreException(String.format("Unable to init Drill Metastore class [%s]", metastoreClass), e);
        }
        if (!(instance instanceof Metastore)) {
            throw new MetastoreException(String.format("Created instance of [%s] does not implement [%s] interface", instance.getClass().getSimpleName(), Metastore.class.getSimpleName()));
        }
        logger.info("Drill Metastore is initiated using {} class", (Object)metastoreClass);
        return (Metastore)instance;
    }

    private DrillConfig createMetastoreConfig(DrillConfig config) {
        return DrillConfig.create(null, null, true, new MetastoreConfigFileInfo(), (ConfigMergeable)config.root());
    }

    @Override
    public void close() throws Exception {
        if (this.metastore != null) {
            this.metastore.close();
        }
    }
}

