/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.user;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.MakeFragmentsVisitor;
import org.apache.drill.exec.planner.fragment.SimpleParallelizer;
import org.apache.drill.exec.planner.fragment.contrib.SplittingParallelizer;
import org.apache.drill.exec.planner.sql.DrillSqlWorker;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.rpc.UserClientConnection;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.util.Pointer;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.foreman.rm.QueryResourceAllocator;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanSplitter {
    static final Logger logger = LoggerFactory.getLogger(PlanSplitter.class);

    public UserProtos.QueryPlanFragments planFragments(DrillbitContext dContext, UserBitShared.QueryId queryId, UserProtos.GetQueryPlanFragments req, UserClientConnection connection) {
        UserProtos.QueryPlanFragments.Builder responseBuilder = UserProtos.QueryPlanFragments.newBuilder();
        QueryContext queryContext = new QueryContext(connection.getSession(), dContext, queryId);
        responseBuilder.setQueryId(queryId);
        try {
            responseBuilder.addAllFragments(this.getFragments(dContext, req, queryContext, queryId));
            responseBuilder.setStatus(UserBitShared.QueryResult.QueryState.COMPLETED);
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to produce PlanFragments for query id \"%s\" with request to %s plan", queryId, req.getSplitPlan() ? "split" : "no split");
            UserBitShared.DrillPBError error = UserBitShared.DrillPBError.newBuilder().setMessage(errorMessage).setErrorType(UserBitShared.DrillPBError.ErrorType.PLAN).build();
            responseBuilder.setStatus(UserBitShared.QueryResult.QueryState.FAILED);
            responseBuilder.setError(error);
        }
        try {
            queryContext.close();
        }
        catch (Exception e) {
            logger.error("Error closing QueryContext when getting plan fragments for query {}.", (Object)QueryIdHelper.getQueryId(queryId), (Object)e);
        }
        return responseBuilder.build();
    }

    private List<BitControl.PlanFragment> getFragments(DrillbitContext dContext, UserProtos.GetQueryPlanFragments req, QueryContext queryContext, UserBitShared.QueryId queryId) throws Exception {
        PhysicalPlan plan;
        String query = req.getQuery();
        switch (req.getType()) {
            case SQL: {
                Pointer<String> textPlan = new Pointer<String>();
                plan = DrillSqlWorker.getPlan(queryContext, query, textPlan);
                break;
            }
            case PHYSICAL: {
                plan = dContext.getPlanReader().readPhysicalPlan(query);
                break;
            }
            default: {
                throw new IllegalStateException("Planning fragments supports only SQL or PHYSICAL QueryType");
            }
        }
        QueryResourceAllocator planner = dContext.getResourceManager().newResourceAllocator(queryContext);
        planner.visitAbstractPlan(plan);
        PhysicalOperator rootOperator = plan.getSortedOperators(false).iterator().next();
        Fragment rootFragment = rootOperator.accept(MakeFragmentsVisitor.INSTANCE, null);
        SplittingParallelizer parallelizer = new SplittingParallelizer(plan.getProperties().hasResourcePlan, queryContext);
        ArrayList<BitControl.PlanFragment> fragments = Lists.newArrayList();
        if (req.getSplitPlan()) {
            List<QueryWorkUnit> queryWorkUnits = ((SimpleParallelizer)parallelizer).getSplitFragments(queryContext.getOptions().getOptionList(), queryContext.getCurrentEndpoint(), queryId, queryContext.getActiveEndpoints(), dContext.getPlanReader(), rootFragment, queryContext.getSession(), queryContext.getQueryContextInfo());
            for (QueryWorkUnit queryWorkUnit : queryWorkUnits) {
                planner.visitPhysicalPlan(queryWorkUnit);
                queryWorkUnit.applyPlan(dContext.getPlanReader());
                fragments.add(queryWorkUnit.getRootFragment());
                List<BitControl.PlanFragment> childFragments = queryWorkUnit.getFragments();
                if (childFragments.isEmpty()) continue;
                throw new IllegalStateException("Split plans can not have more then one fragment");
            }
        } else {
            QueryWorkUnit queryWorkUnit = parallelizer.generateWorkUnit(queryContext.getOptions().getOptionList(), queryContext.getCurrentEndpoint(), queryId, queryContext.getActiveEndpoints(), rootFragment, queryContext.getSession(), queryContext.getQueryContextInfo());
            planner.visitPhysicalPlan(queryWorkUnit);
            queryWorkUnit.applyPlan(dContext.getPlanReader());
            fragments.add(queryWorkUnit.getRootFragment());
            fragments.addAll(queryWorkUnit.getFragments());
        }
        return fragments;
    }
}

