/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.exec.proto.UserBitShared;

public interface QueryQueue {
    public void setMemoryPerNode(long var1);

    public long defaultQueryMemoryPerNode(double var1);

    public long minimumOperatorMemory();

    public boolean enabled();

    public QueueLease enqueue(UserBitShared.QueryId var1, double var2) throws QueueTimeoutException, QueryQueueException;

    public void close();

    public static class QueryQueueException
    extends Exception {
        QueryQueueException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static class QueueTimeoutException
    extends Exception {
        private final UserBitShared.QueryId queryId;
        private final String queueName;
        private final int timeoutMs;

        public QueueTimeoutException(UserBitShared.QueryId queryId, String queueName, int timeoutMs) {
            super(String.format("Query timed out of the %s queue after %,d ms. (%d seconds)", queueName, timeoutMs, (int)Math.round((double)timeoutMs / 1000.0)));
            this.queryId = queryId;
            this.queueName = queueName;
            this.timeoutMs = timeoutMs;
        }

        public UserBitShared.QueryId queryId() {
            return this.queryId;
        }

        public String queueName() {
            return this.queueName;
        }

        public int timeoutMs() {
            return this.timeoutMs;
        }
    }

    public static interface QueueLease {
        public long queryMemoryPerNode();

        public void release();

        public String queueName();
    }
}

