/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ExecConstants;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.foreman.rm.QueryQueue;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class EmbeddedQueryQueue
implements QueryQueue {
    public static String EMBEDDED_QUEUE = "drill.exec.queue.embedded";
    public static String ENABLED = EMBEDDED_QUEUE + ".enable";
    public static String QUEUE_SIZE = EMBEDDED_QUEUE + ".size";
    public static String TIMEOUT_MS = EMBEDDED_QUEUE + ".timeout_ms";
    private final int queueTimeoutMs;
    private final int queueSize;
    private final Semaphore semaphore;
    private long memoryPerQuery;
    private final long minimumOperatorMemory;

    public EmbeddedQueryQueue(DrillbitContext context) {
        DrillConfig config = context.getConfig();
        this.queueTimeoutMs = config.getInt(TIMEOUT_MS);
        this.queueSize = config.getInt(QUEUE_SIZE);
        this.semaphore = new Semaphore(this.queueSize, true);
        this.minimumOperatorMemory = context.getOptionManager().getOption(ExecConstants.MIN_MEMORY_PER_BUFFERED_OP);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void setMemoryPerNode(long memoryPerNode) {
        this.memoryPerQuery = memoryPerNode / (long)this.queueSize;
    }

    @Override
    public long defaultQueryMemoryPerNode(double cost) {
        return this.memoryPerQuery;
    }

    @Override
    public QueryQueue.QueueLease enqueue(UserBitShared.QueryId queryId, double cost) throws QueryQueue.QueueTimeoutException, QueryQueue.QueryQueueException {
        try {
            if (!this.semaphore.tryAcquire(this.queueTimeoutMs, TimeUnit.MILLISECONDS)) {
                throw new QueryQueue.QueueTimeoutException(queryId, "embedded", this.queueTimeoutMs);
            }
        }
        catch (InterruptedException e) {
            throw new QueryQueue.QueryQueueException("Interrupted", e);
        }
        return new EmbeddedQueueLease(queryId, this.memoryPerQuery);
    }

    private void release(EmbeddedQueueLease lease) {
        assert (!lease.released);
        this.semaphore.release();
    }

    @Override
    public void close() {
        assert (this.semaphore.availablePermits() == this.queueSize);
    }

    @Override
    public long minimumOperatorMemory() {
        return this.minimumOperatorMemory;
    }

    public class EmbeddedQueueLease
    implements QueryQueue.QueueLease {
        private final UserBitShared.QueryId queryId;
        private boolean released;
        private long queryMemory;

        public EmbeddedQueueLease(UserBitShared.QueryId queryId, long queryMemory) {
            this.queryId = queryId;
            this.queryMemory = queryMemory;
        }

        public String toString() {
            return "Embedded queue lease for " + QueryIdHelper.getQueryId(this.queryId) + (this.released ? " (released)" : "");
        }

        @Override
        public long queryMemoryPerNode() {
            return this.queryMemory;
        }

        @Override
        public void release() {
            EmbeddedQueryQueue.this.release(this);
            this.released = true;
        }

        @VisibleForTesting
        boolean isReleased() {
            return this.released;
        }

        @Override
        public String queueName() {
            return "local-queue";
        }
    }
}

