/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.resourcemgr.config.ResourcePoolTree;
import org.apache.drill.exec.resourcemgr.config.ResourcePoolTreeImpl;
import org.apache.drill.exec.resourcemgr.config.exception.RMConfigException;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.rm.DefaultResourceManager;
import org.apache.drill.exec.work.foreman.rm.QueryResourceAllocator;
import org.apache.drill.exec.work.foreman.rm.QueryResourceManager;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedResourceManager
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(DistributedResourceManager.class);
    private final ResourcePoolTree rmPoolTree;
    private final DrillbitContext context;
    private final DrillConfig rmConfig;
    private final ResourceManager delegatedRM;

    public DistributedResourceManager(DrillbitContext context) throws DrillRuntimeException {
        try {
            this.context = context;
            this.rmConfig = DrillConfig.createForRM();
            this.rmPoolTree = new ResourcePoolTreeImpl(this.rmConfig, DrillConfig.getMaxDirectMemory(), Runtime.getRuntime().availableProcessors(), 1);
            logger.debug("Successfully parsed RM config \n{}", (Object)this.rmConfig.getConfig("drill.exec.rm"));
            this.delegatedRM = new DefaultResourceManager();
        }
        catch (RMConfigException ex) {
            throw new DrillRuntimeException(String.format("Failed while parsing Drill RM Configs. Drillbit won't be started unless config is fixed or RM is disabled by setting %s to false", "drill.exec.rm.enabled"), ex);
        }
    }

    @Override
    public long memoryPerNode() {
        return this.delegatedRM.memoryPerNode();
    }

    @Override
    public int cpusPerNode() {
        return this.delegatedRM.cpusPerNode();
    }

    @Override
    public QueryResourceAllocator newResourceAllocator(QueryContext queryContext) {
        return this.delegatedRM.newResourceAllocator(queryContext);
    }

    @Override
    public QueryResourceManager newQueryRM(Foreman foreman) {
        return this.delegatedRM.newQueryRM(foreman);
    }

    public ResourcePoolTree getRmPoolTree() {
        return this.rmPoolTree;
    }

    @Override
    public void close() {
        this.delegatedRM.close();
    }
}

