/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.fragment.DefaultQueryParallelizer;
import org.apache.drill.exec.planner.fragment.QueryParallelizer;
import org.apache.drill.exec.util.MemoryAllocationUtilities;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.rm.QueryResourceAllocator;
import org.apache.drill.exec.work.foreman.rm.QueryResourceManager;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;

public class DefaultResourceManager
implements ResourceManager {
    public final long memoryPerNode = DrillConfig.getMaxDirectMemory();
    public final int cpusPerNode = Runtime.getRuntime().availableProcessors();

    @Override
    public long memoryPerNode() {
        return this.memoryPerNode;
    }

    @Override
    public int cpusPerNode() {
        return this.cpusPerNode;
    }

    @Override
    public QueryResourceAllocator newResourceAllocator(QueryContext queryContext) {
        return new DefaultResourceAllocator(queryContext);
    }

    @Override
    public QueryResourceManager newQueryRM(Foreman foreman) {
        return new DefaultQueryResourceManager(this, foreman);
    }

    @Override
    public void close() {
    }

    public static class DefaultResourceAllocator
    implements QueryResourceAllocator {
        private QueryContext queryContext;

        protected DefaultResourceAllocator(QueryContext queryContext) {
            this.queryContext = queryContext;
        }

        @Override
        public void visitAbstractPlan(PhysicalPlan plan) {
            if (plan == null || plan.getProperties().hasResourcePlan) {
                return;
            }
            MemoryAllocationUtilities.setupBufferedMemoryAllocations(plan, this.queryContext);
        }

        @Override
        public void visitPhysicalPlan(QueryWorkUnit work) {
        }

        public QueryContext getQueryContext() {
            return this.queryContext;
        }
    }

    public static class DefaultQueryResourceManager
    extends DefaultResourceAllocator
    implements QueryResourceManager {
        private final DefaultResourceManager rm;

        public DefaultQueryResourceManager(DefaultResourceManager rm, Foreman foreman) {
            super(foreman.getQueryContext());
            this.rm = rm;
        }

        @Override
        public void setCost(double cost) {
        }

        @Override
        public QueryParallelizer getParallelizer(boolean memoryPlanning) {
            return new DefaultQueryParallelizer(memoryPlanning, this.getQueryContext());
        }

        @Override
        public void admit() {
        }

        @Override
        public void exit() {
        }

        @Override
        public boolean hasQueue() {
            return false;
        }

        @Override
        public String queueName() {
            return null;
        }
    }
}

