/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman.rm;

import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.foreman.rm.ResourceManager;

public abstract class AbstractResourceManager
implements ResourceManager {
    protected final DrillbitContext context;
    private final long memoryPerNode;
    private final int cpusPerNode;

    public AbstractResourceManager(DrillbitContext context) {
        this.context = context;
        DrillConfig config = context.getConfig();
        long memLimit = DrillConfig.getMaxDirectMemory();
        long configMemoryPerNode = config.getBytes("drill.exec.rm.memory_per_node");
        if (configMemoryPerNode > 0L) {
            memLimit = Math.min(memLimit, configMemoryPerNode);
        }
        this.memoryPerNode = memLimit;
        int cpuLimit = Runtime.getRuntime().availableProcessors();
        int configCpusPerNode = config.getInt("drill.exec.rm.cpus_per_node");
        if (configCpusPerNode > 0) {
            cpuLimit = Math.min(cpuLimit, configCpusPerNode);
        }
        this.cpusPerNode = cpuLimit;
    }

    @Override
    public long memoryPerNode() {
        return this.memoryPerNode;
    }

    @Override
    public int cpusPerNode() {
        return this.cpusPerNode;
    }
}

