/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import org.apache.drill.common.EventProcessor;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStateProcessor
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryStateProcessor.class);
    private final StateSwitch stateSwitch = new StateSwitch();
    private final String queryIdString;
    private final QueryManager queryManager;
    private final DrillbitContext drillbitContext;
    private final Foreman.ForemanResult foremanResult;
    private volatile UserBitShared.QueryResult.QueryState state;

    public QueryStateProcessor(String queryIdString, QueryManager queryManager, DrillbitContext drillbitContext, Foreman.ForemanResult foremanResult) {
        this.queryIdString = queryIdString;
        this.queryManager = queryManager;
        this.drillbitContext = drillbitContext;
        this.foremanResult = foremanResult;
        this.state = UserBitShared.QueryResult.QueryState.PREPARING;
    }

    public UserBitShared.QueryResult.QueryState getState() {
        return this.state;
    }

    public synchronized void moveToState(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        logger.debug(this.queryIdString + ": State change requested {} --> {}", (Object)this.state, (Object)newState);
        switch (this.state) {
            case PREPARING: {
                this.preparing(newState, exception);
                return;
            }
            case PLANNING: {
                this.planning(newState, exception);
                return;
            }
            case ENQUEUED: {
                this.enqueued(newState, exception);
                return;
            }
            case STARTING: {
                this.starting(newState, exception);
                return;
            }
            case RUNNING: {
                this.running(newState, exception);
                return;
            }
            case CANCELLATION_REQUESTED: {
                this.cancellationRequested(newState, exception);
                return;
            }
            case CANCELED: 
            case COMPLETED: 
            case FAILED: {
                logger.warn("Dropping request to move to {} state as query is already at {} state (which is terminal).", (Object)newState, (Object)this.state);
                return;
            }
        }
        throw new IllegalStateException(String.format("Failure trying to change states: %s --> %s", this.state.name(), newState.name()));
    }

    public void recordNewState(UserBitShared.QueryResult.QueryState newState) {
        this.state = newState;
        this.queryManager.updateEphemeralState(newState);
    }

    public void cancel() {
        switch (this.state) {
            case PREPARING: 
            case PLANNING: 
            case ENQUEUED: 
            case STARTING: 
            case RUNNING: {
                this.moveToState(UserBitShared.QueryResult.QueryState.CANCELLATION_REQUESTED, null);
                break;
            }
            case CANCELLATION_REQUESTED: 
            case CANCELED: 
            case COMPLETED: 
            case FAILED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unable to cancel the query. Unexpected query state -> " + this.state);
            }
        }
    }

    public void addToEventQueue(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        this.stateSwitch.addEvent(newState, exception);
    }

    public void startProcessingEvents() {
        try {
            this.stateSwitch.start();
        }
        catch (Exception ex) {
            this.moveToState(UserBitShared.QueryResult.QueryState.FAILED, ex);
        }
    }

    @Override
    public void close() {
        this.queryManager.markEndTime();
        switch (this.state) {
            case FAILED: {
                this.drillbitContext.getCounters().getFailedQueries().inc();
                break;
            }
            case CANCELED: {
                this.drillbitContext.getCounters().getCanceledQueries().inc();
                break;
            }
            case COMPLETED: {
                this.drillbitContext.getCounters().getSucceededQueries().inc();
            }
        }
        this.drillbitContext.getCounters().getRunningQueries().dec();
        this.drillbitContext.getCounters().getCompletedQueries().inc();
    }

    private void preparing(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        switch (newState) {
            case PLANNING: {
                this.queryManager.markStartTime();
                this.drillbitContext.getCounters().getRunningQueries().inc();
                this.recordNewState(newState);
                this.drillbitContext.getCounters().getPlanningQueries().inc();
                return;
            }
            case CANCELLATION_REQUESTED: {
                this.wrapUpCancellation();
                return;
            }
        }
        this.checkCommonStates(newState, exception);
    }

    private void planning(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        this.drillbitContext.getCounters().getPlanningQueries().dec();
        this.queryManager.markPlanningEndTime();
        switch (newState) {
            case ENQUEUED: {
                this.recordNewState(newState);
                this.drillbitContext.getCounters().getEnqueuedQueries().inc();
                return;
            }
            case CANCELLATION_REQUESTED: {
                this.wrapUpCancellation();
                return;
            }
        }
        this.checkCommonStates(newState, exception);
    }

    private void enqueued(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        this.drillbitContext.getCounters().getEnqueuedQueries().dec();
        this.queryManager.markQueueWaitEndTime();
        switch (newState) {
            case STARTING: {
                this.recordNewState(newState);
                return;
            }
            case CANCELLATION_REQUESTED: {
                this.wrapUpCancellation();
                return;
            }
        }
        this.checkCommonStates(newState, exception);
    }

    private void starting(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        switch (newState) {
            case RUNNING: {
                this.recordNewState(UserBitShared.QueryResult.QueryState.RUNNING);
                return;
            }
            case COMPLETED: {
                this.wrapUpCompletion();
                return;
            }
            case CANCELLATION_REQUESTED: {
                assert (exception == null);
                this.wrapUpCancellation();
                return;
            }
        }
        this.checkCommonStates(newState, exception);
    }

    private void running(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        switch (newState) {
            case CANCELLATION_REQUESTED: {
                assert (exception == null);
                this.wrapUpCancellation();
                return;
            }
            case COMPLETED: {
                this.wrapUpCompletion();
                return;
            }
        }
        this.checkCommonStates(newState, exception);
    }

    private void cancellationRequested(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        switch (newState) {
            case FAILED: {
                if (this.drillbitContext.getConfig().getBoolean("drill.exec.debug.return_error_for_failure_in_cancelled_fragments")) {
                    assert (exception != null);
                    this.recordNewState(UserBitShared.QueryResult.QueryState.FAILED);
                    this.foremanResult.setForceFailure(exception);
                }
            }
            case CANCELED: 
            case COMPLETED: {
                this.foremanResult.close();
                return;
            }
        }
        throw new IllegalStateException(String.format("Failure trying to change states: %s --> %s", this.state.name(), newState.name()));
    }

    private void wrapUpCancellation() {
        this.recordNewState(UserBitShared.QueryResult.QueryState.CANCELLATION_REQUESTED);
        this.queryManager.cancelExecutingFragments(this.drillbitContext);
        this.foremanResult.setCompleted(UserBitShared.QueryResult.QueryState.CANCELED);
    }

    private void wrapUpCompletion() {
        this.recordNewState(UserBitShared.QueryResult.QueryState.COMPLETED);
        this.foremanResult.setCompleted(UserBitShared.QueryResult.QueryState.COMPLETED);
        this.foremanResult.close();
    }

    private void checkCommonStates(UserBitShared.QueryResult.QueryState newState, Exception exception) {
        switch (newState) {
            case FAILED: {
                assert (exception != null);
                this.recordNewState(UserBitShared.QueryResult.QueryState.FAILED);
                this.queryManager.cancelExecutingFragments(this.drillbitContext);
                this.foremanResult.setFailed(exception);
                this.foremanResult.close();
                return;
            }
        }
        throw new IllegalStateException(String.format("Failure trying to change states: %s --> %s", this.state.name(), newState.name()));
    }

    private class StateSwitch
    extends EventProcessor<StateEvent> {
        private StateSwitch() {
        }

        public void addEvent(UserBitShared.QueryResult.QueryState newState, Exception exception) {
            this.sendEvent(new StateEvent(newState, exception));
        }

        @Override
        protected void processEvent(StateEvent event) {
            QueryStateProcessor.this.moveToState(event.newState, event.exception);
        }
    }

    private class StateEvent {
        final UserBitShared.QueryResult.QueryState newState;
        final Exception exception;

        StateEvent(UserBitShared.QueryResult.QueryState newState, Exception exception) {
            this.newState = newState;
            this.exception = exception;
        }
    }
}

