/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.foreman;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.SocketAddress;
import java.util.Date;
import org.apache.drill.exec.proto.UserBitShared;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedQuery {
    static final Logger logger = LoggerFactory.getLogger(LoggedQuery.class);
    private final String queryId;
    private final String schema;
    private final String queryText;
    private final Date start;
    private final Date finish;
    private final UserBitShared.QueryResult.QueryState outcome;
    private final String username;
    private final SocketAddress remoteAddress;

    public LoggedQuery(String queryId, String schema, String queryText, Date start, Date finish, UserBitShared.QueryResult.QueryState outcome, String username, SocketAddress remoteAddress) {
        this.queryId = queryId;
        this.schema = schema;
        this.queryText = queryText;
        this.start = start;
        this.finish = finish;
        this.outcome = outcome;
        this.username = username;
        this.remoteAddress = remoteAddress;
    }

    @JsonProperty(value="id")
    public String getQueryId() {
        return this.queryId;
    }

    public String getSchema() {
        return this.schema;
    }

    @JsonProperty(value="query")
    public String getQueryText() {
        return this.queryText;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getFinish() {
        return this.finish;
    }

    public UserBitShared.QueryResult.QueryState getOutcome() {
        return this.outcome;
    }

    @JsonProperty(value="user")
    public String getUsername() {
        return this.username;
    }

    public String getRemoteAddress() {
        return this.remoteAddress.toString().replace("/", "");
    }
}

