/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.work.batch.RawBatchBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRawBatchBuffer<T>
implements RawBatchBuffer {
    private static final Logger logger = LoggerFactory.getLogger(BaseRawBatchBuffer.class);
    protected BufferQueue<T> bufferQueue;
    private volatile BufferState state = BufferState.INIT;
    protected final int bufferSizePerSocket;
    protected final AtomicBoolean outOfMemory = new AtomicBoolean(false);
    private int streamCounter;
    private final int fragmentCount;
    protected final FragmentContext context;
    protected final boolean enableDynamicFC;

    public BaseRawBatchBuffer(FragmentContext context, int fragmentCount, boolean enableDynamicFC) {
        this.bufferSizePerSocket = context.getConfig().getInt("drill.exec.buffer.size");
        this.fragmentCount = fragmentCount;
        this.streamCounter = fragmentCount;
        this.context = context;
        this.enableDynamicFC = enableDynamicFC;
    }

    protected int getFragmentCount() {
        return this.fragmentCount;
    }

    @Override
    public synchronized void enqueue(RawFragmentBatch batch) throws IOException {
        if (this.context != null && !this.context.getExecutorState().shouldContinue()) {
            this.kill(this.context);
        }
        if (this.isTerminated()) {
            if (this.state == BufferState.KILLED) {
                batch.release();
                batch.sendOk();
                return;
            }
            throw new IOException("Attempted to enqueue batch after finished");
        }
        this.enqueueInner(batch);
    }

    protected abstract void enqueueInner(RawFragmentBatch var1) throws IOException;

    @Override
    public void close() {
        if (!this.isTerminated() && this.context.getExecutorState().shouldContinue()) {
            String msg = String.format("Cleanup before finished. %d out of %d streams have finished", this.completedStreams(), this.fragmentCount);
            throw new IllegalStateException(msg);
        }
        if (!this.bufferQueue.isEmpty()) {
            if (this.context.getExecutorState().shouldContinue()) {
                this.context.getExecutorState().fail(new IllegalStateException("Batches still in queue during cleanup"));
                logger.error("{} Batches in queue.", (Object)this.bufferQueue.size());
            }
            this.clearBufferWithBody();
        }
    }

    @Override
    public synchronized void kill(FragmentContext context) {
        this.state = BufferState.KILLED;
        this.clearBufferWithBody();
    }

    private void clearBufferWithBody() {
        while (!this.bufferQueue.isEmpty()) {
            RawFragmentBatch batch = null;
            try {
                batch = this.bufferQueue.poll();
                this.assertAckSent(batch);
            }
            catch (IOException e) {
                this.context.getExecutorState().fail(e);
            }
            catch (InterruptedException e) {
                this.context.getExecutorState().fail(e);
                Thread.currentThread().interrupt();
            }
            finally {
                if (batch == null || batch.getBody() == null) continue;
                batch.getBody().release();
            }
        }
    }

    private void allStreamsFinished() {
        if (this.state != BufferState.KILLED) {
            this.state = BufferState.STREAMS_FINISHED;
        }
        if (!this.bufferQueue.isEmpty()) {
            throw new IllegalStateException("buffer not empty when finished");
        }
    }

    @Override
    public RawFragmentBatch getNext() throws IOException {
        RawFragmentBatch b;
        if (this.outOfMemory.get() && this.bufferQueue.size() < 10) {
            this.outOfMemory.set(false);
        }
        try {
            b = this.bufferQueue.poll();
            if (!(b != null || this.isTerminated() && this.bufferQueue.isEmpty())) {
                while (b == null) {
                    b = this.bufferQueue.poll(5L, TimeUnit.SECONDS);
                    if (this.context.getExecutorState().shouldContinue()) continue;
                    this.kill(this.context);
                    if (b == null) continue;
                    this.assertAckSent(b);
                    if (b.getBody() != null) {
                        b.getBody().release();
                    }
                    b = null;
                }
            }
        }
        catch (InterruptedException e) {
            if (this.context.getExecutorState().shouldContinue()) {
                throw new DrillRuntimeException("Interrupted but context.shouldContinue() is true", e);
            }
            this.kill(this.context);
            Thread.currentThread().interrupt();
            return null;
        }
        if (this.context.getAllocator().isOverLimit()) {
            this.outOfMemory.set(true);
        }
        if (b != null) {
            this.upkeep(b);
            if (b.getHeader().getIsLastBatch()) {
                logger.debug("Got last batch from {}:{}", (Object)b.getHeader().getSendingMajorFragmentId(), (Object)b.getHeader().getSendingMinorFragmentId());
                int remainingStreams = this.decrementStreamCounter();
                if (remainingStreams == 0) {
                    logger.debug("Streams finished");
                    this.allStreamsFinished();
                }
            }
        } else {
            if (!this.bufferQueue.isEmpty()) {
                throw new IllegalStateException("Returning null when there are batches left in queue");
            }
            if (!this.isTerminated()) {
                throw new IllegalStateException("Returning null when not finished");
            }
        }
        this.assertAckSent(b);
        return b;
    }

    private void assertAckSent(RawFragmentBatch batch) {
        assert (batch == null || batch.isAckSent()) : "Ack not sent for batch";
    }

    private int decrementStreamCounter() {
        --this.streamCounter;
        return this.streamCounter;
    }

    private int completedStreams() {
        return this.fragmentCount - this.streamCounter;
    }

    protected abstract void upkeep(RawFragmentBatch var1);

    protected boolean isTerminated() {
        return this.state == BufferState.KILLED || this.state == BufferState.STREAMS_FINISHED;
    }

    private static enum BufferState {
        INIT,
        STREAMS_FINISHED,
        KILLED;

    }

    protected static interface BufferQueue<T> {
        public void addOomBatch(RawFragmentBatch var1);

        public RawFragmentBatch poll() throws IOException, InterruptedException;

        public RawFragmentBatch take() throws IOException, InterruptedException;

        public RawFragmentBatch poll(long var1, TimeUnit var3) throws InterruptedException, IOException;

        public boolean checkForOutOfMemory();

        public int size();

        public boolean isEmpty();

        public void add(T var1);
    }
}

