/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.work.batch;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.util.ArrayWrappedIntIntMap;
import org.apache.drill.exec.work.batch.DataCollector;
import org.apache.drill.exec.work.batch.RawBatchBuffer;
import org.apache.drill.exec.work.batch.SpoolingRawBatchBuffer;
import org.apache.drill.exec.work.batch.UnlimitedRawBatchBuffer;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;

public abstract class AbstractDataCollector
implements DataCollector {
    private final int oppositeMajorFragmentId;
    private final AtomicIntegerArray remainders;
    private final AtomicInteger remainingRequired;
    private final AtomicInteger parentAccounter;
    private final int incomingStreams;
    protected final RawBatchBuffer[] buffers;
    protected final ArrayWrappedIntIntMap fragmentMap;
    protected BufferAllocator ownerAllocator;

    public AbstractDataCollector(AtomicInteger parentAccounter, int numBuffers, BitControl.Collector collector, int bufferCapacity, FragmentContext context) {
        Preconditions.checkNotNull(collector);
        Preconditions.checkNotNull(parentAccounter);
        this.incomingStreams = collector.getIncomingMinorFragmentCount();
        this.parentAccounter = parentAccounter;
        this.remainders = new AtomicIntegerArray(this.incomingStreams);
        this.oppositeMajorFragmentId = collector.getOppositeMajorFragmentId();
        this.ownerAllocator = context.getAllocator();
        this.fragmentMap = new ArrayWrappedIntIntMap();
        int index = 0;
        for (Integer endpoint : collector.getIncomingMinorFragmentList()) {
            this.fragmentMap.put(endpoint, index);
            ++index;
        }
        this.buffers = new RawBatchBuffer[numBuffers];
        this.remainingRequired = new AtomicInteger(numBuffers);
        boolean spooling = collector.getIsSpooling();
        boolean enableDynamicFc = collector.hasEnableDynamicFc();
        for (int i = 0; i < numBuffers; ++i) {
            this.buffers[i] = spooling ? new SpoolingRawBatchBuffer(context, bufferCapacity, collector.getOppositeMajorFragmentId(), i, enableDynamicFc) : new UnlimitedRawBatchBuffer(context, bufferCapacity, enableDynamicFc);
        }
    }

    @Override
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }

    @Override
    public RawBatchBuffer[] getBuffers() {
        return this.buffers;
    }

    @Override
    public boolean batchArrived(int minorFragmentId, RawFragmentBatch batch) throws IOException {
        int rem;
        boolean decrementedToZero = false;
        if (this.remainders.compareAndSet(this.fragmentMap.get(minorFragmentId), 0, 1) && (rem = this.remainingRequired.decrementAndGet()) == 0) {
            decrementedToZero = 0 == this.parentAccounter.decrementAndGet();
        }
        this.getBuffer(minorFragmentId).enqueue(batch);
        return decrementedToZero;
    }

    @Override
    public int getTotalIncomingFragments() {
        return this.incomingStreams;
    }

    protected abstract RawBatchBuffer getBuffer(int var1);

    @Override
    public void close() throws Exception {
        AutoCloseables.close(this.buffers);
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.ownerAllocator;
    }

    @Override
    public void setAllocator(BufferAllocator allocator) {
        Preconditions.checkArgument(allocator != null, "buffer allocator cannot be null");
        this.ownerAllocator = allocator;
    }
}

