/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableVar16CharHolder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Var16CharWriter;

public class Var16CharHolderReaderImpl
extends AbstractFieldReader {
    private Var16CharHolder holder;

    public Var16CharHolderReaderImpl(Var16CharHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return Var16CharHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(Var16CharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
    }

    @Override
    public void read(NullableVar16CharHolder h) {
        h.start = this.holder.start;
        h.end = this.holder.end;
        h.buffer = this.holder.buffer;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public String readString() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return new String(value);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        int length = this.holder.end - this.holder.start;
        byte[] value = new byte[length];
        this.holder.buffer.getBytes(this.holder.start, value, 0, length);
        return new String(value);
    }

    @Override
    public void copyAsValue(Var16CharWriter writer) {
        if (this.isSet()) {
            writer.writeVar16Char(this.holder.start, this.holder.end, this.holder.buffer);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        Var16CharWriter impl = writer.var16Char(name);
        if (this.isSet()) {
            impl.writeVar16Char(this.holder.start, this.holder.end, this.holder.buffer);
        }
    }
}

