/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import java.math.BigDecimal;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.BigIntHolder;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.Float4Holder;
import org.apache.drill.exec.expr.holders.Float8Holder;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.IntervalDayHolder;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.IntervalYearHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.TimeHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.expr.holders.TinyIntHolder;
import org.apache.drill.exec.expr.holders.UInt1Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.expr.holders.UInt4Holder;
import org.apache.drill.exec.expr.holders.UInt8Holder;
import org.apache.drill.exec.expr.holders.Var16CharHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.exec.expr.holders.VarDecimalHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.MapVector;
import org.apache.drill.exec.vector.complex.Positionable;
import org.apache.drill.exec.vector.complex.UnionVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import org.apache.drill.exec.vector.complex.impl.NullableBigIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableBitWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableDateWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableFloat8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalDayWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableIntervalYearWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableSmallIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeStampWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTimeWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableTinyIntWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt1WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt2WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt4WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableUInt8WriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVar16CharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarBinaryWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarCharWriterImpl;
import org.apache.drill.exec.vector.complex.impl.NullableVarDecimalWriterImpl;
import org.apache.drill.exec.vector.complex.impl.SingleDictWriter;
import org.apache.drill.exec.vector.complex.impl.SingleMapWriter;
import org.apache.drill.exec.vector.complex.impl.UnionListWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalYearWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;
import org.apache.drill.exec.vector.complex.writer.TinyIntWriter;
import org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import org.apache.drill.exec.vector.complex.writer.UInt2Writer;
import org.apache.drill.exec.vector.complex.writer.UInt4Writer;
import org.apache.drill.exec.vector.complex.writer.UInt8Writer;
import org.apache.drill.exec.vector.complex.writer.Var16CharWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;

public class UnionVectorWriter
extends AbstractFieldWriter {
    final Map<TypeProtos.MinorType, FieldWriter> typeWriters = new TypeWritersMap();
    final UnionVector dataVector;

    public UnionVectorWriter(UnionVector vector, FieldWriter parent) {
        super(parent);
        this.dataVector = vector;
    }

    @Override
    public UnionVectorWriter union() {
        return this;
    }

    @Override
    public BaseWriter.MapWriter map() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.MAP, type -> new SingleMapUnionWriter(this.dataVector.getMap(), null, false));
    }

    @Override
    public BaseWriter.DictWriter dict() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.DICT, type -> new SingleDictUnionWriter(this.dataVector.getDict(), null, false));
    }

    @Override
    public BaseWriter.ListWriter list() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.LIST, listType -> new ListUnionWriter(this.dataVector.getList()));
    }

    @Override
    public TinyIntWriter tinyInt() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.TINYINT, x$0 -> new TinyIntUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public UInt1Writer uInt1() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.UINT1, x$0 -> new UInt1UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public UInt2Writer uInt2() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.UINT2, x$0 -> new UInt2UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public SmallIntWriter smallInt() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.SMALLINT, x$0 -> new SmallIntUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public IntWriter integer() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.INT, x$0 -> new IntUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public UInt4Writer uInt4() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.UINT4, x$0 -> new UInt4UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public Float4Writer float4() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.FLOAT4, x$0 -> new Float4UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public TimeWriter time() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.TIME, x$0 -> new TimeUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public IntervalYearWriter intervalYear() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.INTERVALYEAR, x$0 -> new IntervalYearUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public BigIntWriter bigInt() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.BIGINT, x$0 -> new BigIntUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public UInt8Writer uInt8() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.UINT8, x$0 -> new UInt8UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public Float8Writer float8() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.FLOAT8, x$0 -> new Float8UnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public DateWriter date() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.DATE, x$0 -> new DateUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public TimeStampWriter timeStamp() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.TIMESTAMP, x$0 -> new TimeStampUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public IntervalDayWriter intervalDay() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.INTERVALDAY, x$0 -> new IntervalDayUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public IntervalWriter interval() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.INTERVAL, x$0 -> new IntervalUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public VarBinaryWriter varBinary() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.VARBINARY, x$0 -> new VarBinaryUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public VarCharWriter varChar() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.VARCHAR, x$0 -> new VarCharUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public Var16CharWriter var16Char() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.VAR16CHAR, x$0 -> new Var16CharUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public VarDecimalWriter varDecimal() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.VARDECIMAL, x$0 -> new VarDecimalUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public VarDecimalWriter varDecimal(int precision, int scale) {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.VARDECIMAL, type -> new VarDecimalUnionWriter((TypeProtos.MinorType)type, precision, scale));
    }

    @Override
    public BitWriter bit() {
        return this.typeWriters.computeIfAbsent(TypeProtos.MinorType.BIT, x$0 -> new BitUnionWriter((TypeProtos.MinorType)x$0));
    }

    @Override
    public void allocate() {
        this.dataVector.allocateNew();
    }

    @Override
    public void clear() {
        this.dataVector.clear();
    }

    @Override
    public int getValueCapacity() {
        return this.dataVector.getValueCapacity();
    }

    @Override
    public MaterializedField getField() {
        return this.dataVector.getField();
    }

    @Override
    public void close() throws Exception {
        this.dataVector.close();
    }

    @Override
    public void writeNull() {
        this.dataVector.getMutator().setNull(this.idx());
    }

    private void setTypeAndIndex(TypeProtos.MinorType type, Positionable positionable) {
        this.dataVector.getMutator().setType(this.idx(), type);
        positionable.setPosition(this.idx());
    }

    private class TypeWritersMap
    extends EnumMap<TypeProtos.MinorType, FieldWriter> {
        TypeWritersMap() {
            super(TypeProtos.MinorType.class);
        }

        @Override
        public FieldWriter computeIfAbsent(TypeProtos.MinorType key, Function<? super TypeProtos.MinorType, ? extends FieldWriter> mappingFunction) {
            FieldWriter fw = (FieldWriter)this.get(key);
            if (fw == null) {
                fw = mappingFunction.apply(key);
                this.put(key, fw);
            }
            UnionVectorWriter.this.setTypeAndIndex(key, fw);
            return fw;
        }
    }

    class BitUnionWriter
    extends NullableBitWriterImpl {
        private final TypeProtos.MinorType type;

        BitUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getBitVector(), null);
            this.type = type;
        }

        @Override
        public void writeBit(int value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeBit(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(BitHolder holder) {
            this.writeBit(holder.value);
        }
    }

    class VarDecimalUnionWriter
    extends NullableVarDecimalWriterImpl {
        private final TypeProtos.MinorType type;

        VarDecimalUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getVarDecimalVector(), null);
            this.type = type;
        }

        VarDecimalUnionWriter(TypeProtos.MinorType type, int precision, int scale) {
            this(type);
            MaterializedField field = this.vector.getField();
            TypeProtos.MajorType typeWithPrecisionAndScale = field.getType().toBuilder().setPrecision(precision).setScale(scale).build();
            field.replaceType(typeWithPrecisionAndScale);
        }

        @Override
        public void writeVarDecimal(BigDecimal value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeVarDecimal(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void writeVarDecimal(int start, int end, DrillBuf buffer, int precision, int scale) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeVarDecimal(start, end, buffer, precision, scale);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(VarDecimalHolder holder) {
            this.writeVarDecimal(holder.start, holder.end, holder.buffer, holder.precision, holder.scale);
        }
    }

    class Var16CharUnionWriter
    extends NullableVar16CharWriterImpl {
        private final TypeProtos.MinorType type;

        Var16CharUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getVar16CharVector(), null);
            this.type = type;
        }

        @Override
        public void writeVar16Char(int start, int end, DrillBuf buffer) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeVar16Char(start, end, buffer);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(Var16CharHolder holder) {
            this.writeVar16Char(holder.start, holder.end, holder.buffer);
        }
    }

    class VarCharUnionWriter
    extends NullableVarCharWriterImpl {
        private final TypeProtos.MinorType type;

        VarCharUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getVarCharVector(), null);
            this.type = type;
        }

        @Override
        public void writeVarChar(int start, int end, DrillBuf buffer) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeVarChar(start, end, buffer);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(VarCharHolder holder) {
            this.writeVarChar(holder.start, holder.end, holder.buffer);
        }
    }

    class VarBinaryUnionWriter
    extends NullableVarBinaryWriterImpl {
        private final TypeProtos.MinorType type;

        VarBinaryUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getVarBinaryVector(), null);
            this.type = type;
        }

        @Override
        public void writeVarBinary(int start, int end, DrillBuf buffer) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeVarBinary(start, end, buffer);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(VarBinaryHolder holder) {
            this.writeVarBinary(holder.start, holder.end, holder.buffer);
        }
    }

    class IntervalUnionWriter
    extends NullableIntervalWriterImpl {
        private final TypeProtos.MinorType type;

        IntervalUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getIntervalVector(), null);
            this.type = type;
        }

        @Override
        public void writeInterval(int months, int days, int milliseconds) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeInterval(months, days, milliseconds);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(IntervalHolder holder) {
            this.writeInterval(holder.months, holder.days, holder.milliseconds);
        }
    }

    class IntervalDayUnionWriter
    extends NullableIntervalDayWriterImpl {
        private final TypeProtos.MinorType type;

        IntervalDayUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getIntervalDayVector(), null);
            this.type = type;
        }

        @Override
        public void writeIntervalDay(int days, int milliseconds) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeIntervalDay(days, milliseconds);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(IntervalDayHolder holder) {
            this.writeIntervalDay(holder.days, holder.milliseconds);
        }
    }

    class TimeStampUnionWriter
    extends NullableTimeStampWriterImpl {
        private final TypeProtos.MinorType type;

        TimeStampUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getTimeStampVector(), null);
            this.type = type;
        }

        @Override
        public void writeTimeStamp(long value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeTimeStamp(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(TimeStampHolder holder) {
            this.writeTimeStamp(holder.value);
        }
    }

    class DateUnionWriter
    extends NullableDateWriterImpl {
        private final TypeProtos.MinorType type;

        DateUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getDateVector(), null);
            this.type = type;
        }

        @Override
        public void writeDate(long value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeDate(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(DateHolder holder) {
            this.writeDate(holder.value);
        }
    }

    class Float8UnionWriter
    extends NullableFloat8WriterImpl {
        private final TypeProtos.MinorType type;

        Float8UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getFloat8Vector(), null);
            this.type = type;
        }

        @Override
        public void writeFloat8(double value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeFloat8(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(Float8Holder holder) {
            this.writeFloat8(holder.value);
        }
    }

    class UInt8UnionWriter
    extends NullableUInt8WriterImpl {
        private final TypeProtos.MinorType type;

        UInt8UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getUInt8Vector(), null);
            this.type = type;
        }

        @Override
        public void writeUInt8(long value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeUInt8(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(UInt8Holder holder) {
            this.writeUInt8(holder.value);
        }
    }

    class BigIntUnionWriter
    extends NullableBigIntWriterImpl {
        private final TypeProtos.MinorType type;

        BigIntUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getBigIntVector(), null);
            this.type = type;
        }

        @Override
        public void writeBigInt(long value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeBigInt(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(BigIntHolder holder) {
            this.writeBigInt(holder.value);
        }
    }

    class IntervalYearUnionWriter
    extends NullableIntervalYearWriterImpl {
        private final TypeProtos.MinorType type;

        IntervalYearUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getIntervalYearVector(), null);
            this.type = type;
        }

        @Override
        public void writeIntervalYear(int value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeIntervalYear(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(IntervalYearHolder holder) {
            this.writeIntervalYear(holder.value);
        }
    }

    class TimeUnionWriter
    extends NullableTimeWriterImpl {
        private final TypeProtos.MinorType type;

        TimeUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getTimeVector(), null);
            this.type = type;
        }

        @Override
        public void writeTime(int value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeTime(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(TimeHolder holder) {
            this.writeTime(holder.value);
        }
    }

    class Float4UnionWriter
    extends NullableFloat4WriterImpl {
        private final TypeProtos.MinorType type;

        Float4UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getFloat4Vector(), null);
            this.type = type;
        }

        @Override
        public void writeFloat4(float value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeFloat4(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(Float4Holder holder) {
            this.writeFloat4(holder.value);
        }
    }

    class UInt4UnionWriter
    extends NullableUInt4WriterImpl {
        private final TypeProtos.MinorType type;

        UInt4UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getUInt4Vector(), null);
            this.type = type;
        }

        @Override
        public void writeUInt4(int value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeUInt4(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(UInt4Holder holder) {
            this.writeUInt4(holder.value);
        }
    }

    class IntUnionWriter
    extends NullableIntWriterImpl {
        private final TypeProtos.MinorType type;

        IntUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getIntVector(), null);
            this.type = type;
        }

        @Override
        public void writeInt(int value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeInt(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(IntHolder holder) {
            this.writeInt(holder.value);
        }
    }

    class SmallIntUnionWriter
    extends NullableSmallIntWriterImpl {
        private final TypeProtos.MinorType type;

        SmallIntUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getSmallIntVector(), null);
            this.type = type;
        }

        @Override
        public void writeSmallInt(short value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeSmallInt(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(SmallIntHolder holder) {
            this.writeSmallInt(holder.value);
        }
    }

    class UInt2UnionWriter
    extends NullableUInt2WriterImpl {
        private final TypeProtos.MinorType type;

        UInt2UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getUInt2Vector(), null);
            this.type = type;
        }

        @Override
        public void writeUInt2(char value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeUInt2(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(UInt2Holder holder) {
            this.writeUInt2(holder.value);
        }
    }

    class UInt1UnionWriter
    extends NullableUInt1WriterImpl {
        private final TypeProtos.MinorType type;

        UInt1UnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getUInt1Vector(), null);
            this.type = type;
        }

        @Override
        public void writeUInt1(byte value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeUInt1(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(UInt1Holder holder) {
            this.writeUInt1(holder.value);
        }
    }

    class TinyIntUnionWriter
    extends NullableTinyIntWriterImpl {
        private final TypeProtos.MinorType type;

        TinyIntUnionWriter(TypeProtos.MinorType type) {
            super(UnionVectorWriter.this.dataVector.getTinyIntVector(), null);
            this.type = type;
        }

        @Override
        public void writeTinyInt(byte value) {
            UnionVectorWriter.this.setTypeAndIndex(this.type, this);
            super.writeTinyInt(value);
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public void write(TinyIntHolder holder) {
            this.writeTinyInt(holder.value);
        }
    }

    class ListUnionWriter
    extends UnionListWriter {
        ListUnionWriter(ListVector vector) {
            super(vector);
        }

        @Override
        public void startList() {
            UnionVectorWriter.this.dataVector.getMutator().setType(UnionVectorWriter.this.idx(), TypeProtos.MinorType.LIST);
            super.startList();
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }

        @Override
        public TinyIntWriter tinyInt() {
            this.writer.getWriter(TypeProtos.MinorType.TINYINT);
            return super.tinyInt();
        }

        @Override
        public UInt1Writer uInt1() {
            this.writer.getWriter(TypeProtos.MinorType.UINT1);
            return super.uInt1();
        }

        @Override
        public UInt2Writer uInt2() {
            this.writer.getWriter(TypeProtos.MinorType.UINT2);
            return super.uInt2();
        }

        @Override
        public SmallIntWriter smallInt() {
            this.writer.getWriter(TypeProtos.MinorType.SMALLINT);
            return super.smallInt();
        }

        @Override
        public IntWriter integer() {
            this.writer.getWriter(TypeProtos.MinorType.INT);
            return super.integer();
        }

        @Override
        public UInt4Writer uInt4() {
            this.writer.getWriter(TypeProtos.MinorType.UINT4);
            return super.uInt4();
        }

        @Override
        public Float4Writer float4() {
            this.writer.getWriter(TypeProtos.MinorType.FLOAT4);
            return super.float4();
        }

        @Override
        public TimeWriter time() {
            this.writer.getWriter(TypeProtos.MinorType.TIME);
            return super.time();
        }

        @Override
        public IntervalYearWriter intervalYear() {
            this.writer.getWriter(TypeProtos.MinorType.INTERVALYEAR);
            return super.intervalYear();
        }

        @Override
        public BigIntWriter bigInt() {
            this.writer.getWriter(TypeProtos.MinorType.BIGINT);
            return super.bigInt();
        }

        @Override
        public UInt8Writer uInt8() {
            this.writer.getWriter(TypeProtos.MinorType.UINT8);
            return super.uInt8();
        }

        @Override
        public Float8Writer float8() {
            this.writer.getWriter(TypeProtos.MinorType.FLOAT8);
            return super.float8();
        }

        @Override
        public DateWriter date() {
            this.writer.getWriter(TypeProtos.MinorType.DATE);
            return super.date();
        }

        @Override
        public TimeStampWriter timeStamp() {
            this.writer.getWriter(TypeProtos.MinorType.TIMESTAMP);
            return super.timeStamp();
        }

        @Override
        public IntervalDayWriter intervalDay() {
            this.writer.getWriter(TypeProtos.MinorType.INTERVALDAY);
            return super.intervalDay();
        }

        @Override
        public IntervalWriter interval() {
            this.writer.getWriter(TypeProtos.MinorType.INTERVAL);
            return super.interval();
        }

        @Override
        public VarBinaryWriter varBinary() {
            this.writer.getWriter(TypeProtos.MinorType.VARBINARY);
            return super.varBinary();
        }

        @Override
        public VarCharWriter varChar() {
            this.writer.getWriter(TypeProtos.MinorType.VARCHAR);
            return super.varChar();
        }

        @Override
        public Var16CharWriter var16Char() {
            this.writer.getWriter(TypeProtos.MinorType.VAR16CHAR);
            return super.var16Char();
        }

        @Override
        public VarDecimalWriter varDecimal() {
            this.writer.getWriter(TypeProtos.MinorType.VARDECIMAL);
            return super.varDecimal();
        }

        @Override
        public BitWriter bit() {
            this.writer.getWriter(TypeProtos.MinorType.BIT);
            return super.bit();
        }
    }

    class SingleDictUnionWriter
    extends SingleDictWriter {
        SingleDictUnionWriter(DictVector container, FieldWriter parent, boolean unionEnabled) {
            super(container, parent, unionEnabled);
        }

        @Override
        public void start() {
            UnionVectorWriter.this.dataVector.getMutator().setType(UnionVectorWriter.this.idx(), TypeProtos.MinorType.DICT);
            super.start();
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }
    }

    class SingleMapUnionWriter
    extends SingleMapWriter {
        SingleMapUnionWriter(MapVector container, FieldWriter parent, boolean unionEnabled) {
            super(container, parent, unionEnabled);
        }

        @Override
        public void start() {
            UnionVectorWriter.this.dataVector.getMutator().setType(UnionVectorWriter.this.idx(), TypeProtos.MinorType.MAP);
            super.start();
            UnionVectorWriter.this.dataVector.getMutator().setValueCount(this.idx() + 1);
        }
    }
}

