/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import org.apache.drill.exec.vector.complex.impl.PromotableWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BigIntWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.DateWriter;
import org.apache.drill.exec.vector.complex.writer.Float4Writer;
import org.apache.drill.exec.vector.complex.writer.Float8Writer;
import org.apache.drill.exec.vector.complex.writer.IntWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalDayWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalYearWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;
import org.apache.drill.exec.vector.complex.writer.TimeWriter;
import org.apache.drill.exec.vector.complex.writer.TinyIntWriter;
import org.apache.drill.exec.vector.complex.writer.UInt1Writer;
import org.apache.drill.exec.vector.complex.writer.UInt2Writer;
import org.apache.drill.exec.vector.complex.writer.UInt4Writer;
import org.apache.drill.exec.vector.complex.writer.UInt8Writer;
import org.apache.drill.exec.vector.complex.writer.Var16CharWriter;
import org.apache.drill.exec.vector.complex.writer.VarBinaryWriter;
import org.apache.drill.exec.vector.complex.writer.VarCharWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;

public class UnionListWriter
extends AbstractFieldWriter {
    protected PromotableWriter writer;
    private ListVector vector;
    private UInt4Vector offsets;
    private boolean inMap = false;

    public UnionListWriter(ListVector vector) {
        super(null);
        this.vector = vector;
        this.writer = new PromotableWriter(vector.getDataVector(), vector);
        this.offsets = vector.getOffsetVector();
    }

    public UnionListWriter(ListVector vector, AbstractFieldWriter parent) {
        this(vector);
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public MaterializedField getField() {
        return null;
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public TinyIntWriter tinyInt() {
        return this;
    }

    @Override
    public TinyIntWriter tinyInt(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        TinyIntWriter tinyIntWriter = this.writer.tinyInt(name);
        return tinyIntWriter;
    }

    @Override
    public UInt1Writer uInt1() {
        return this;
    }

    @Override
    public UInt1Writer uInt1(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        UInt1Writer uInt1Writer = this.writer.uInt1(name);
        return uInt1Writer;
    }

    @Override
    public UInt2Writer uInt2() {
        return this;
    }

    @Override
    public UInt2Writer uInt2(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        UInt2Writer uInt2Writer = this.writer.uInt2(name);
        return uInt2Writer;
    }

    @Override
    public SmallIntWriter smallInt() {
        return this;
    }

    @Override
    public SmallIntWriter smallInt(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        SmallIntWriter smallIntWriter = this.writer.smallInt(name);
        return smallIntWriter;
    }

    @Override
    public IntWriter integer() {
        return this;
    }

    @Override
    public IntWriter integer(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        IntWriter intWriter = this.writer.integer(name);
        return intWriter;
    }

    @Override
    public UInt4Writer uInt4() {
        return this;
    }

    @Override
    public UInt4Writer uInt4(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        UInt4Writer uInt4Writer = this.writer.uInt4(name);
        return uInt4Writer;
    }

    @Override
    public Float4Writer float4() {
        return this;
    }

    @Override
    public Float4Writer float4(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        Float4Writer float4Writer = this.writer.float4(name);
        return float4Writer;
    }

    @Override
    public TimeWriter time() {
        return this;
    }

    @Override
    public TimeWriter time(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        TimeWriter timeWriter = this.writer.time(name);
        return timeWriter;
    }

    @Override
    public IntervalYearWriter intervalYear() {
        return this;
    }

    @Override
    public IntervalYearWriter intervalYear(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        IntervalYearWriter intervalYearWriter = this.writer.intervalYear(name);
        return intervalYearWriter;
    }

    @Override
    public BigIntWriter bigInt() {
        return this;
    }

    @Override
    public BigIntWriter bigInt(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        BigIntWriter bigIntWriter = this.writer.bigInt(name);
        return bigIntWriter;
    }

    @Override
    public UInt8Writer uInt8() {
        return this;
    }

    @Override
    public UInt8Writer uInt8(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        UInt8Writer uInt8Writer = this.writer.uInt8(name);
        return uInt8Writer;
    }

    @Override
    public Float8Writer float8() {
        return this;
    }

    @Override
    public Float8Writer float8(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        Float8Writer float8Writer = this.writer.float8(name);
        return float8Writer;
    }

    @Override
    public DateWriter date() {
        return this;
    }

    @Override
    public DateWriter date(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        DateWriter dateWriter = this.writer.date(name);
        return dateWriter;
    }

    @Override
    public TimeStampWriter timeStamp() {
        return this;
    }

    @Override
    public TimeStampWriter timeStamp(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        TimeStampWriter timeStampWriter = this.writer.timeStamp(name);
        return timeStampWriter;
    }

    @Override
    public IntervalDayWriter intervalDay() {
        return this;
    }

    @Override
    public IntervalDayWriter intervalDay(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        IntervalDayWriter intervalDayWriter = this.writer.intervalDay(name);
        return intervalDayWriter;
    }

    @Override
    public IntervalWriter interval() {
        return this;
    }

    @Override
    public IntervalWriter interval(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        IntervalWriter intervalWriter = this.writer.interval(name);
        return intervalWriter;
    }

    @Override
    public VarBinaryWriter varBinary() {
        return this;
    }

    @Override
    public VarBinaryWriter varBinary(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        VarBinaryWriter varBinaryWriter = this.writer.varBinary(name);
        return varBinaryWriter;
    }

    @Override
    public VarCharWriter varChar() {
        return this;
    }

    @Override
    public VarCharWriter varChar(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        VarCharWriter varCharWriter = this.writer.varChar(name);
        return varCharWriter;
    }

    @Override
    public Var16CharWriter var16Char() {
        return this;
    }

    @Override
    public Var16CharWriter var16Char(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        Var16CharWriter var16CharWriter = this.writer.var16Char(name);
        return var16CharWriter;
    }

    @Override
    public VarDecimalWriter varDecimal() {
        return this;
    }

    @Override
    public VarDecimalWriter varDecimal(String name, int precision, int scale) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        VarDecimalWriter varDecimalWriter = this.writer.varDecimal(name, precision, scale);
        return varDecimalWriter;
    }

    @Override
    public BitWriter bit() {
        return this;
    }

    @Override
    public BitWriter bit(String name) {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        BitWriter bitWriter = this.writer.bit(name);
        return bitWriter;
    }

    @Override
    public BaseWriter.MapWriter map() {
        this.inMap = true;
        return this;
    }

    @Override
    public BaseWriter.ListWriter list() {
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
        this.writer.setPosition(nextOffset);
        return this.writer;
    }

    @Override
    public BaseWriter.ListWriter list(String name) {
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        BaseWriter.ListWriter listWriter = this.writer.list(name);
        return listWriter;
    }

    @Override
    public BaseWriter.MapWriter map(String name) {
        BaseWriter.MapWriter mapWriter = this.writer.map(name);
        return mapWriter;
    }

    @Override
    public void startList() {
        this.vector.getMutator().startNewValue(this.idx());
    }

    @Override
    public void endList() {
    }

    @Override
    public void start() {
        assert (this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset);
        this.writer.setPosition(nextOffset);
    }

    @Override
    public void end() {
        if (this.inMap) {
            this.inMap = false;
            int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
            this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
        }
    }

    @Override
    public void writeTinyInt(byte value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeTinyInt(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeUInt1(byte value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeUInt1(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeUInt2(char value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeUInt2(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeSmallInt(short value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeSmallInt(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeInt(int value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeInt(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeUInt4(int value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeUInt4(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeFloat4(float value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeFloat4(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeTime(int value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeTime(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeIntervalYear(int value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeIntervalYear(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeBigInt(long value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeBigInt(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeUInt8(long value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeUInt8(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeFloat8(double value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeFloat8(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeDate(long value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeDate(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeTimeStamp(long value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeTimeStamp(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeIntervalDay(int days, int milliseconds) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeIntervalDay(days, milliseconds);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeInterval(int months, int days, int milliseconds) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeInterval(months, days, milliseconds);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeVarBinary(int start, int end, DrillBuf buffer) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeVarBinary(start, end, buffer);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeVarChar(int start, int end, DrillBuf buffer) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeVarChar(start, end, buffer);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeVar16Char(int start, int end, DrillBuf buffer) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeVar16Char(start, end, buffer);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeVarDecimal(int start, int end, DrillBuf buffer, int precision, int scale) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeVarDecimal(start, end, buffer, precision, scale);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }

    @Override
    public void writeBit(int value) {
        assert (!this.inMap);
        int nextOffset = this.offsets.getAccessor().get(this.idx() + 1);
        this.vector.getMutator().setNotNull(this.idx());
        this.writer.setPosition(nextOffset);
        this.writer.writeBit(value);
        this.offsets.getMutator().setSafe(this.idx() + 1, nextOffset + 1);
    }
}

