/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.UnionHolder;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class UnionListReader
extends AbstractFieldReader {
    private ListVector vector;
    private ValueVector data;
    private UInt4Vector offsets;
    TypeProtos.MajorType type = Types.optional(TypeProtos.MinorType.LIST);
    private int currentOffset;
    private int maxOffset;

    public UnionListReader(ListVector vector) {
        this.vector = vector;
        this.data = vector.getDataVector();
        this.offsets = vector.getOffsetVector();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.type;
    }

    @Override
    public void setPosition(int index) {
        super.setPosition(index);
        this.currentOffset = this.offsets.getAccessor().get(index) - 1;
        this.maxOffset = this.offsets.getAccessor().get(index + 1);
    }

    @Override
    public FieldReader reader() {
        return this.data.getReader();
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    @Override
    public void read(int index, UnionHolder holder) {
        this.setPosition(this.idx());
        for (int i = -1; i < index; ++i) {
            this.next();
        }
        holder.reader = this.data.getReader();
        holder.isSet = this.data.getReader().isSet() ? 1 : 0;
    }

    @Override
    public boolean next() {
        if (this.currentOffset + 1 < this.maxOffset) {
            this.data.getReader().setPosition(++this.currentOffset);
            return true;
        }
        return false;
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        ComplexCopier.copy(this, (FieldWriter)writer);
    }
}

