/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.SmallIntVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.SmallIntWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;

public class SmallIntReaderImpl
extends AbstractFieldReader {
    private final SmallIntVector vector;

    public SmallIntReaderImpl(SmallIntVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(SmallIntWriter writer) {
        SmallIntWriterImpl impl = (SmallIntWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        SmallIntWriterImpl impl = (SmallIntWriterImpl)writer.smallInt(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(SmallIntHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public void read(ValueHolder h) {
        if (h instanceof SmallIntHolder) {
            this.read((SmallIntHolder)h);
        } else {
            this.read((NullableSmallIntHolder)h);
        }
    }

    @Override
    public void read(NullableSmallIntHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Short readShort() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

