/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableSmallIntHolder;
import org.apache.drill.exec.expr.holders.SmallIntHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.SmallIntWriter;

public class SmallIntHolderReaderImpl
extends AbstractFieldReader {
    private SmallIntHolder holder;

    public SmallIntHolderReaderImpl(SmallIntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return SmallIntHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(SmallIntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableSmallIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Short readShort() {
        Short value = new Short(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        Short value = new Short(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(SmallIntWriter writer) {
        if (this.isSet()) {
            writer.writeSmallInt(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        SmallIntWriter impl = writer.smallInt(name);
        if (this.isSet()) {
            impl.writeSmallInt(this.holder.value);
        }
    }
}

