/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.expr.holders.DictHolder;
import org.apache.drill.exec.vector.complex.DictVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;
import org.apache.drill.exec.vector.complex.impl.AbstractRepeatedMapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class SingleDictWriter
extends AbstractRepeatedMapWriter<DictVector>
implements BaseWriter.DictWriter {
    private boolean mapStarted;

    public SingleDictWriter(DictVector container, FieldWriter parent, boolean unionEnabled) {
        super(container, parent, unionEnabled);
    }

    public SingleDictWriter(DictVector container, FieldWriter parent) {
        this(container, parent, false);
    }

    @Override
    public void start() {
        assert (!this.mapStarted) : "Map should not be started";
        if (((DictVector)this.container).getValueCapacity() <= this.idx()) {
            ((DictVector)this.container).getMutator().setValueCount(this.idx() + 1);
        }
        DictHolder h = new DictHolder();
        ((DictVector)this.container).getAccessor().get(this.idx(), h);
        if (h.start >= h.end) {
            ((DictVector)this.container).getMutator().startNewValue(this.idx());
        }
        this.mapStarted = true;
    }

    @Override
    public void end() {
        this.checkStarted();
        this.mapStarted = false;
    }

    @Override
    public void startKeyValuePair() {
        this.checkStarted();
        this.currentChildIndex = ((DictVector)this.container).getMutator().add(this.idx());
        for (FieldWriter w : this.fields.values()) {
            w.setPosition(this.currentChildIndex);
        }
    }

    @Override
    public void endKeyValuePair() {
        this.checkStarted();
        if (((DictVector)this.container).getKeys().getAccessor().getValueCount() == this.currentChildIndex) {
            throw new DrillRuntimeException("Key in DICT cannot be null. Index: " + this.idx());
        }
        if (((DictVector)this.container).getValues() != null && ((DictVector)this.container).isValueNullable() && ((DictVector)this.container).getValues().getAccessor().getValueCount() == this.currentChildIndex) {
            ((AbstractFieldWriter)this.getValueWriter()).writeNull();
        }
    }

    @Override
    public FieldWriter getKeyWriter() {
        return (FieldWriter)this.fields.get("key");
    }

    @Override
    public FieldWriter getValueWriter() {
        return (FieldWriter)this.fields.get("value");
    }

    private void checkStarted() {
        assert (this.mapStarted) : "Must start map (startRow()) before";
    }
}

