/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.NullableUInt2Holder;
import org.apache.drill.exec.expr.holders.UInt2Holder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.RepeatedUInt2Vector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class RepeatedUInt2WriterImpl
extends AbstractFieldWriter {
    private final RepeatedUInt2Vector.Mutator mutator;
    final RepeatedUInt2Vector vector;

    public RepeatedUInt2WriterImpl(RepeatedUInt2Vector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(UInt2Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableUInt2Holder h) {
        this.mutator.addSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeUInt2(char value) {
        this.mutator.addSafe(this.idx(), value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void setPosition(int idx) {
        super.setPosition(idx);
        if (idx >= this.vector.getAccessor().getValueCount()) {
            this.mutator.startNewValue(idx);
        }
    }
}

