/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableVarDecimalHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableVarDecimalVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableVarDecimalWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.VarDecimalWriter;

public class NullableVarDecimalReaderImpl
extends AbstractFieldReader {
    private final NullableVarDecimalVector vector;

    public NullableVarDecimalReaderImpl(NullableVarDecimalVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(VarDecimalWriter writer) {
        NullableVarDecimalWriterImpl impl = (NullableVarDecimalWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    public void copyAsField(String name, BaseWriter.MapWriter writer, int precision, int scale) {
        NullableVarDecimalWriterImpl impl = (NullableVarDecimalWriterImpl)writer.varDecimal(name, precision, scale);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h) {
        this.read((NullableVarDecimalHolder)h);
    }

    @Override
    public void read(NullableVarDecimalHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public BigDecimal readBigDecimal() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

