/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableTimeStampHolder;
import org.apache.drill.exec.expr.holders.TimeStampHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.TimeStampWriter;

public class NullableTimeStampHolderReaderImpl
extends AbstractFieldReader {
    private NullableTimeStampHolder holder;

    public NullableTimeStampHolderReaderImpl(NullableTimeStampHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return NullableTimeStampHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return this.holder.isSet == 1;
    }

    @Override
    public void read(TimeStampHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableTimeStampHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public LocalDateTime readLocalDateTime() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(this.holder.value), ZoneOffset.UTC);
    }

    @Override
    public void copyAsValue(TimeStampWriter writer) {
        if (this.isSet()) {
            writer.writeTimeStamp(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        TimeStampWriter impl = writer.timeStamp(name);
        if (this.isSet()) {
            impl.writeTimeStamp(this.holder.value);
        }
    }
}

