/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.expr.holders.Decimal28SparseHolder;
import org.apache.drill.exec.expr.holders.NullableDecimal28SparseHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableDecimal28SparseVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableDecimal28SparseWriterImpl
extends AbstractFieldWriter {
    private final NullableDecimal28SparseVector.Mutator mutator;
    final NullableDecimal28SparseVector vector;

    public NullableDecimal28SparseWriterImpl(NullableDecimal28SparseVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(Decimal28SparseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDecimal28SparseHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDecimal28Sparse(int start, DrillBuf buffer, int precision, int scale) {
        this.mutator.setSafe(this.idx(), 1, start, buffer);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

