/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableDecimal28DenseVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableDecimal28DenseWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.Decimal28DenseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class NullableDecimal28DenseReaderImpl
extends AbstractFieldReader {
    private final NullableDecimal28DenseVector vector;

    public NullableDecimal28DenseReaderImpl(NullableDecimal28DenseVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(Decimal28DenseWriter writer) {
        NullableDecimal28DenseWriterImpl impl = (NullableDecimal28DenseWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableDecimal28DenseWriterImpl impl = (NullableDecimal28DenseWriterImpl)writer.decimal28Dense(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h) {
        this.read((NullableDecimal28DenseHolder)h);
    }

    @Override
    public void read(NullableDecimal28DenseHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public BigDecimal readBigDecimal() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

