/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.exec.expr.holders.DateHolder;
import org.apache.drill.exec.expr.holders.NullableDateHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableDateVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldWriter;

public class NullableDateWriterImpl
extends AbstractFieldWriter {
    private final NullableDateVector.Mutator mutator;
    final NullableDateVector vector;

    public NullableDateWriterImpl(NullableDateVector vector, AbstractFieldWriter parent) {
        super(parent);
        this.mutator = vector.getMutator();
        this.vector = vector;
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    public void write(DateHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    public void write(NullableDateHolder h) {
        this.mutator.setSafe(this.idx(), h);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.mutator.setNull(this.idx());
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }

    @Override
    public void writeDate(long value) {
        this.mutator.setSafe(this.idx(), 1, value);
        this.vector.getMutator().setValueCount(this.idx() + 1);
    }
}

