/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.NullableBitVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullableBitWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.BitWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;

public class NullableBitReaderImpl
extends AbstractFieldReader {
    private final NullableBitVector vector;

    public NullableBitReaderImpl(NullableBitVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return !this.vector.getAccessor().isNull(this.idx());
    }

    @Override
    public void copyAsValue(BitWriter writer) {
        NullableBitWriterImpl impl = (NullableBitWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        NullableBitWriterImpl impl = (NullableBitWriterImpl)writer.bit(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(ValueHolder h) {
        this.read((NullableBitHolder)h);
    }

    @Override
    public void read(NullableBitHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Boolean readBoolean() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

