/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.IntervalHolder;
import org.apache.drill.exec.expr.holders.NullableIntervalHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.vector.IntervalVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.IntervalWriterImpl;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.apache.drill.exec.vector.complex.writer.IntervalWriter;
import org.joda.time.Period;

public class IntervalReaderImpl
extends AbstractFieldReader {
    private final IntervalVector vector;

    public IntervalReaderImpl(IntervalVector vector) {
        this.vector = vector;
    }

    @Override
    public TypeProtos.MajorType getType() {
        return this.vector.getField().getType();
    }

    @Override
    public MaterializedField getField() {
        return this.vector.getField();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void copyAsValue(IntervalWriter writer) {
        IntervalWriterImpl impl = (IntervalWriterImpl)writer;
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        IntervalWriterImpl impl = (IntervalWriterImpl)writer.interval(name);
        impl.vector.copyFromSafe(this.idx(), impl.idx(), this.vector);
    }

    @Override
    public void read(IntervalHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public void read(ValueHolder h) {
        if (h instanceof IntervalHolder) {
            this.read((IntervalHolder)h);
        } else {
            this.read((NullableIntervalHolder)h);
        }
    }

    @Override
    public void read(NullableIntervalHolder h) {
        this.vector.getAccessor().get(this.idx(), h);
    }

    @Override
    public Period readPeriod() {
        return this.vector.getAccessor().getObject(this.idx());
    }

    public void copyValue(FieldWriter w) {
    }

    @Override
    public Object readObject() {
        return this.vector.getAccessor().getObject(this.idx());
    }
}

