/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.IntHolder;
import org.apache.drill.exec.expr.holders.NullableIntHolder;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.apache.drill.exec.vector.complex.writer.IntWriter;

public class IntHolderReaderImpl
extends AbstractFieldReader {
    private IntHolder holder;

    public IntHolderReaderImpl(IntHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return IntHolder.TYPE;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntHolder h) {
        h.value = this.holder.value;
    }

    @Override
    public void read(NullableIntHolder h) {
        h.value = this.holder.value;
        h.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public Integer readInteger() {
        Integer value = new Integer(this.holder.value);
        return value;
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        Integer value = new Integer(this.holder.value);
        return value;
    }

    @Override
    public void copyAsValue(IntWriter writer) {
        if (this.isSet()) {
            writer.writeInt(this.holder.value);
        }
    }

    @Override
    public void copyAsField(String name, BaseWriter.MapWriter writer) {
        IntWriter impl = writer.integer(name);
        if (this.isSet()) {
            impl.writeInt(this.holder.value);
        }
    }
}

