/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.holders.RepeatedMapHolder;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.exec.vector.complex.impl.NullReader;
import org.apache.drill.exec.vector.complex.reader.FieldReader;

public abstract class AbstractRepeatedMapReaderImpl<V extends AbstractRepeatedMapVector>
extends AbstractFieldReader {
    protected static final int NO_VALUES = 0x7FFFFFFE;
    protected final V vector;
    protected final Map<String, FieldReader> fields = new HashMap<String, FieldReader>();
    protected int currentOffset;
    protected int maxOffset;

    public AbstractRepeatedMapReaderImpl(V vector) {
        this.vector = vector;
    }

    @Override
    public FieldReader reader(String name) {
        FieldReader reader = this.fields.get(name);
        if (reader == null) {
            ValueVector child = ((AbstractContainerVector)this.vector).getChild(name);
            reader = child == null ? NullReader.INSTANCE : child.getReader();
            this.fields.put(name, reader);
            reader.setPosition(this.currentOffset);
        }
        return reader;
    }

    @Override
    public void reset() {
        super.reset();
        this.currentOffset = 0;
        this.maxOffset = 0;
        for (FieldReader reader : this.fields.values()) {
            reader.reset();
        }
        this.fields.clear();
    }

    @Override
    public int size() {
        UInt4Vector.Accessor offsetsAccessor = ((AbstractRepeatedMapVector)this.vector).getOffsetVector().getAccessor();
        return this.isEmpty() ? 0 : offsetsAccessor.get(this.idx() + 1) - offsetsAccessor.get(this.idx());
    }

    @Override
    public void setPosition(int index) {
        if (index < 0 || index == 0x7FFFFFFE) {
            this.currentOffset = 0x7FFFFFFE;
            return;
        }
        super.setPosition(index);
        RepeatedMapHolder h = new RepeatedMapHolder();
        ((AbstractRepeatedMapVector)this.vector).getAccessor().get(index, h);
        if (h.start == h.end) {
            this.currentOffset = 0x7FFFFFFE;
        } else {
            this.currentOffset = h.start - 1;
            this.maxOffset = h.end - 1;
            this.setChildrenPosition(this.currentOffset);
        }
    }

    @Override
    public boolean next() {
        if (this.currentOffset < this.maxOffset) {
            this.setChildrenPosition(++this.currentOffset);
            return true;
        }
        this.currentOffset = 0x7FFFFFFE;
        return false;
    }

    public boolean isEmpty() {
        return this.currentOffset == 0x7FFFFFFE;
    }

    @Override
    public Object readObject() {
        return ((AbstractRepeatedMapVector)this.vector).getAccessor().getObject(this.idx());
    }

    @Override
    public TypeProtos.MajorType getType() {
        return ((AbstractContainerVector)this.vector).getField().getType();
    }

    @Override
    public Iterator<String> iterator() {
        return ((AbstractRepeatedMapVector)this.vector).fieldNameIterator();
    }

    @Override
    public boolean isSet() {
        return true;
    }

    void setChildrenPosition(int index) {
        for (FieldReader r : this.fields.values()) {
            r.setPosition(index);
        }
    }
}

