/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.complex.fn;

import io.netty.buffer.DrillBuf;
import java.io.IOException;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarCharHolder;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkingBuffer {
    static final Logger logger = LoggerFactory.getLogger(WorkingBuffer.class);
    private DrillBuf workBuf;

    public WorkingBuffer(DrillBuf workBuf) {
        this.workBuf = workBuf;
    }

    private void ensure(int length) {
        this.workBuf = this.workBuf.reallocIfNeeded(length);
    }

    public void prepareVarCharHolder(String value, VarCharHolder h) throws IOException {
        byte[] b = value.getBytes(Charsets.UTF_8);
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        h.start = 0;
        h.end = b.length;
        h.buffer = this.workBuf;
    }

    public int prepareVarCharHolder(String value) throws IOException {
        byte[] b = value.getBytes(Charsets.UTF_8);
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        return b.length;
    }

    public void prepareBinary(byte[] b, VarBinaryHolder h) throws IOException {
        this.ensure(b.length);
        this.workBuf.setBytes(0, b);
        h.start = 0;
        h.end = b.length;
        h.buffer = this.workBuf;
    }

    public DrillBuf getBuf() {
        return this.workBuf;
    }
}

