/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.accessor.ColumnReader;
import org.apache.drill.exec.vector.accessor.InvalidConversionError;
import org.apache.drill.exec.vector.accessor.ValueType;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractFixedWidthWriter;
import org.apache.drill.exec.vector.accessor.writer.OffsetVectorWriter;

public class OffsetVectorWriterImpl
extends AbstractFixedWidthWriter
implements OffsetVectorWriter {
    private static final int VALUE_WIDTH = 4;
    private final UInt4Vector vector;
    private int rowStartOffset;
    protected int nextOffset;

    public OffsetVectorWriterImpl(UInt4Vector vector) {
        this.vector = vector;
    }

    @Override
    public BaseDataValueVector vector() {
        return this.vector;
    }

    @Override
    public int width() {
        return 4;
    }

    @Override
    protected void realloc(int size) {
        this.vector.reallocRaw(size);
        this.setBuffer();
    }

    @Override
    public ValueType valueType() {
        return ValueType.INTEGER;
    }

    @Override
    public void startWrite() {
        super.startWrite();
        this.nextOffset = 0;
        this.rowStartOffset = 0;
        if (this.capacity * 4 < 256) {
            this.realloc(256);
        }
        this.drillBuf.setInt(0, 0);
    }

    @Override
    public int nextOffset() {
        return this.nextOffset;
    }

    @Override
    public int rowStartOffset() {
        return this.rowStartOffset;
    }

    @Override
    public void startRow() {
        this.rowStartOffset = this.nextOffset;
    }

    protected final int prepareWrite() {
        int valueIndex = this.prepareFill();
        int fillCount = valueIndex - this.lastWriteIndex - 1;
        if (fillCount > 0) {
            this.fillEmpties(fillCount);
        }
        this.lastWriteIndex = valueIndex;
        return valueIndex + 1;
    }

    public final int prepareFill() {
        int valueIndex = this.vectorIndex.vectorIndex();
        if (valueIndex + 1 < this.capacity) {
            return valueIndex;
        }
        this.resize(valueIndex + 1);
        return this.vectorIndex.vectorIndex();
    }

    @Override
    protected final void fillEmpties(int fillCount) {
        for (int i = 0; i < fillCount; ++i) {
            this.fillOffset(this.nextOffset);
        }
    }

    @Override
    public final void setNextOffset(int newOffset) {
        int writeIndex = this.prepareWrite();
        this.drillBuf.setInt(writeIndex * 4, newOffset);
        this.nextOffset = newOffset;
    }

    public final void reviseOffset(int newOffset) {
        int writeIndex = this.vectorIndex.vectorIndex() + 1;
        this.drillBuf.setInt(writeIndex * 4, newOffset);
        this.nextOffset = newOffset;
    }

    public final void fillOffset(int newOffset) {
        this.drillBuf.setInt((++this.lastWriteIndex + 1) * 4, newOffset);
        this.nextOffset = newOffset;
    }

    @Override
    public final void setValue(Object value) {
        throw new InvalidConversionError("setValue() not supported for the offset vector writer: " + value);
    }

    @Override
    public void skipNulls() {
    }

    @Override
    public void restartRow() {
        this.nextOffset = this.rowStartOffset;
        super.restartRow();
    }

    @Override
    public void preRollover() {
        this.setValueCount(this.vectorIndex.rowStartIndex());
    }

    @Override
    public void postRollover() {
        int newNext = this.nextOffset - this.rowStartOffset;
        super.postRollover();
        this.nextOffset = newNext;
    }

    @Override
    public void setValueCount(int valueCount) {
        if (valueCount == 0) {
            this.vector().getBuffer().writerIndex(0);
        } else {
            int offsetCount = valueCount + 1;
            this.mandatoryResize(offsetCount);
            this.fillEmpties(valueCount - this.lastWriteIndex - 1);
            this.vector().getBuffer().writerIndex(offsetCount * 4);
        }
    }

    @Override
    public void dump(HierarchicalFormatter format) {
        format.extend();
        super.dump(format);
        format.attribute("lastWriteIndex", this.lastWriteIndex).attribute("nextOffset", this.nextOffset).endObject();
    }

    @Override
    public void setDefaultValue(Object value) {
        throw new UnsupportedOperationException("Encoding not supported for offset vectors");
    }

    @Override
    public void copy(ColumnReader from) {
        throw new UnsupportedOperationException("Copying of offset vectors not supported");
    }
}

