/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import java.lang.reflect.Array;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.accessor.ColumnAccessors;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import org.apache.drill.exec.vector.accessor.writer.AbstractArrayWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractScalarWriterImpl;
import org.apache.drill.exec.vector.accessor.writer.ObjectArrayWriter;
import org.apache.drill.exec.vector.accessor.writer.dummy.DummyScalarWriter;
import org.apache.drill.exec.vector.complex.ListVector;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;

public class ListWriterImpl
extends ObjectArrayWriter {
    private final ListVector vector;
    private final AbstractScalarWriterImpl isSetWriter;

    public ListWriterImpl(ColumnMetadata schema, ListVector vector, AbstractObjectWriter memberWriter) {
        super(schema, vector == null ? null : vector.getOffsetVector(), memberWriter);
        this.vector = vector;
        this.isSetWriter = vector == null ? new DummyScalarWriter(null) : new ColumnAccessors.UInt1ColumnWriter(vector.getBitsVector());
        this.elementIndex = new AbstractArrayWriter.ArrayElementWriterIndex();
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        super.bindIndex(index);
        this.isSetWriter.bindIndex(index);
    }

    @VisibleForTesting
    public ListVector vector() {
        return this.vector;
    }

    @Override
    public void setNull(boolean isNull) {
        if (this.elementIndex.arraySize() > 0 && isNull) {
            throw new IllegalStateException();
        }
        this.isSetWriter.setInt(isNull ? 0 : 1);
    }

    @Override
    public void startWrite() {
        super.startWrite();
        this.isSetWriter.startWrite();
    }

    @Override
    public void startRow() {
        super.startRow();
        this.isSetWriter.startRow();
    }

    @Override
    public void endArrayValue() {
        if (this.elementIndex.arraySize() > 0) {
            this.setNull(false);
        }
        super.endArrayValue();
    }

    @Override
    public void restartRow() {
        super.restartRow();
        this.isSetWriter.restartRow();
    }

    @Override
    public void saveRow() {
        super.saveRow();
        this.isSetWriter.saveRow();
    }

    @Override
    public void preRollover() {
        super.preRollover();
        this.isSetWriter.preRollover();
    }

    @Override
    public void postRollover() {
        super.postRollover();
        this.isSetWriter.postRollover();
    }

    @Override
    public void endWrite() {
        this.isSetWriter.endWrite();
        super.endWrite();
    }

    @Override
    public void setObject(Object array) {
        this.setNull(array == null);
        if (array == null) {
            return;
        }
        int size = Array.getLength(array);
        for (int i = 0; i < size; ++i) {
            Object value = Array.get(array, i);
            if (value != null) {
                this.elementObjWriter.setObject(value);
            } else if (this.elementObjWriter.nullable()) {
                this.elementObjWriter.setNull();
            }
            this.save();
        }
    }
}

