/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.writer;

import java.util.List;
import java.util.Map;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.accessor.ColumnReader;
import org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import org.apache.drill.exec.vector.complex.DictVector;

public class DictEntryWriter
extends AbstractTupleWriter {
    private final ColumnMetadata dictColumnSchema;

    public static DictEntryObjectWriter buildDictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> keyValueWriters, DictVector vector) {
        DictEntryWriter dictEntryWriter = vector != null ? new DictEntryWriter(schema, keyValueWriters) : new DummyDictEntryWriter(schema, keyValueWriters);
        return new DictEntryObjectWriter(dictEntryWriter);
    }

    public DictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
        super(schema.tupleSchema(), writers);
        this.dictColumnSchema = schema;
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.bindIndex(index, new AbstractTupleWriter.MemberWriterIndex(index));
    }

    @Override
    public boolean isProjected() {
        return true;
    }

    @Override
    public ColumnMetadata schema() {
        return this.dictColumnSchema;
    }

    @Override
    public void setObject(Object value) {
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            this.set(0, entry.getKey());
            this.set(1, entry.getValue());
        } else {
            super.setObject(value);
        }
    }

    private static class DummyDictEntryWriter
    extends DictEntryWriter {
        DummyDictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
            super(schema, writers);
        }

        @Override
        public boolean isProjected() {
            return false;
        }

        @Override
        public void copy(ColumnReader from) {
        }
    }

    public static class DictEntryObjectWriter
    extends AbstractTupleWriter.TupleObjectWriter {
        public DictEntryObjectWriter(DictEntryWriter entryWriter) {
            super(entryWriter);
        }

        void setKeyValue(Object key, Object value) {
            this.tupleWriter.set(0, key);
            this.tupleWriter.set(1, value);
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("dictEntryWriter");
            this.tupleWriter.dump(format);
            format.endObject();
        }
    }
}

