/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.reader;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.VariantMetadata;
import org.apache.drill.exec.vector.accessor.ArrayReader;
import org.apache.drill.exec.vector.accessor.ColumnAccessors;
import org.apache.drill.exec.vector.accessor.ColumnReader;
import org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import org.apache.drill.exec.vector.accessor.ObjectReader;
import org.apache.drill.exec.vector.accessor.ObjectType;
import org.apache.drill.exec.vector.accessor.ScalarReader;
import org.apache.drill.exec.vector.accessor.TupleReader;
import org.apache.drill.exec.vector.accessor.VariantReader;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import org.apache.drill.exec.vector.accessor.reader.ReaderEvents;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessors;
import org.apache.drill.exec.vector.complex.UnionVector;

public class UnionReaderImpl
implements VariantReader,
ReaderEvents {
    private final ColumnMetadata schema;
    private final VectorAccessor unionAccessor;
    private final VectorAccessor typeAccessor;
    private final ColumnAccessors.UInt1ColumnReader typeReader;
    private final AbstractObjectReader[] variants;
    protected NullStateReader nullStateReader;

    public UnionReaderImpl(ColumnMetadata schema, VectorAccessor va, AbstractObjectReader[] variants) {
        this.schema = schema;
        this.unionAccessor = va;
        this.typeReader = new ColumnAccessors.UInt1ColumnReader();
        this.typeReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        if (va.isHyper()) {
            this.typeAccessor = new VectorAccessors.UnionTypeHyperVectorAccessor(va);
        } else {
            UnionVector unionVector = (UnionVector)va.vector();
            this.typeAccessor = new VectorAccessors.SingleVectorAccessor(unionVector.getTypeVector());
        }
        this.typeReader.bindVector(null, this.typeAccessor);
        this.nullStateReader = new NullStateReaders.TypeVectorStateReader(this.typeReader);
        assert (variants != null && variants.length == TypeProtos.MinorType.values().length);
        this.variants = variants;
        this.rebindMemberNullState();
    }

    private void rebindMemberNullState() {
        for (int i = 0; i < this.variants.length; ++i) {
            NullStateReader nullReader;
            AbstractObjectReader objReader = this.variants[i];
            if (objReader == null) continue;
            TypeProtos.MinorType type = TypeProtos.MinorType.values()[i];
            switch (type) {
                case DICT: 
                case MAP: 
                case LIST: {
                    nullReader = new NullStateReaders.ComplexMemberStateReader(this.typeReader, type);
                    break;
                }
                default: {
                    nullReader = new NullStateReaders.MemberNullStateReader(this.nullStateReader, objReader.events().nullStateReader());
                }
            }
            objReader.events().bindNullState(nullReader);
        }
    }

    public static AbstractObjectReader build(ColumnMetadata schema, VectorAccessor va, AbstractObjectReader[] variants) {
        return new UnionObjectReader(new UnionReaderImpl(schema, va, variants));
    }

    @Override
    public void bindNullState(NullStateReader nullStateReader) {
    }

    @Override
    public NullStateReader nullStateReader() {
        return this.nullStateReader;
    }

    @Override
    public void bindIndex(ColumnReaderIndex index) {
        this.unionAccessor.bind(index);
        this.typeAccessor.bind(index);
        this.typeReader.bindIndex(index);
        this.nullStateReader.bindIndex(index);
        for (AbstractObjectReader variant : this.variants) {
            if (variant == null) continue;
            variant.events().bindIndex(index);
        }
    }

    @Override
    public ObjectType type() {
        return ObjectType.VARIANT;
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public VariantMetadata variantSchema() {
        return this.schema.variantSchema();
    }

    @Override
    public int size() {
        return this.variantSchema().size();
    }

    @Override
    public boolean hasType(TypeProtos.MinorType type) {
        return this.variants[type.ordinal()] != null;
    }

    @Override
    public void reposition() {
        for (AbstractObjectReader variantReader : this.variants) {
            if (variantReader == null) continue;
            variantReader.events().reposition();
        }
    }

    @Override
    public void bindBuffer() {
        for (AbstractObjectReader variantReader : this.variants) {
            if (variantReader == null) continue;
            variantReader.events().bindBuffer();
        }
        this.nullStateReader.bindBuffer();
    }

    @Override
    public boolean isNull() {
        return this.nullStateReader.isNull();
    }

    @Override
    public TypeProtos.MinorType dataType() {
        int typeCode = this.typeReader.getInt();
        if (typeCode == 0) {
            return null;
        }
        return TypeProtos.MinorType.forNumber(typeCode);
    }

    @Override
    public ObjectReader member(TypeProtos.MinorType type) {
        return this.variants[type.ordinal()];
    }

    private ObjectReader requireReader(TypeProtos.MinorType type) {
        ObjectReader reader = this.member(type);
        if (reader == null) {
            throw new IllegalArgumentException("Union does not include type " + type.toString());
        }
        return reader;
    }

    @Override
    public ScalarReader scalar(TypeProtos.MinorType type) {
        return this.requireReader(type).scalar();
    }

    @Override
    public ObjectReader member() {
        TypeProtos.MinorType type = this.dataType();
        if (type == null) {
            return null;
        }
        return this.member(type);
    }

    @Override
    public ScalarReader scalar() {
        ObjectReader reader = this.member();
        if (reader == null) {
            return null;
        }
        return reader.scalar();
    }

    @Override
    public TupleReader tuple() {
        return this.requireReader(TypeProtos.MinorType.MAP).tuple();
    }

    @Override
    public ArrayReader array() {
        return this.requireReader(TypeProtos.MinorType.LIST).array();
    }

    @Override
    public Object getObject() {
        TypeProtos.MinorType type = this.dataType();
        if (type == null) {
            return null;
        }
        return this.requireReader(type).getObject();
    }

    @Override
    public String getAsString() {
        TypeProtos.MinorType type = this.dataType();
        if (type == null) {
            return "null";
        }
        return this.requireReader(type).getAsString();
    }

    public static class UnionObjectReader
    extends AbstractObjectReader {
        private final UnionReaderImpl reader;

        public UnionObjectReader(UnionReaderImpl reader) {
            this.reader = reader;
        }

        @Override
        public VariantReader variant() {
            return this.reader;
        }

        @Override
        public Object getObject() {
            return this.reader.getObject();
        }

        @Override
        public String getAsString() {
            return this.reader.getAsString();
        }

        @Override
        public ReaderEvents events() {
            return this.reader;
        }

        @Override
        public ColumnReader reader() {
            return this.reader;
        }
    }
}

