/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.vector.accessor.DictReader;
import org.apache.drill.exec.vector.accessor.KeyAccessor;
import org.apache.drill.exec.vector.accessor.KeyAccessors;
import org.apache.drill.exec.vector.accessor.ObjectReader;
import org.apache.drill.exec.vector.accessor.ObjectType;
import org.apache.drill.exec.vector.accessor.ScalarReader;
import org.apache.drill.exec.vector.accessor.ValueType;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.AbstractTupleReader;
import org.apache.drill.exec.vector.accessor.reader.ArrayReaderImpl;
import org.apache.drill.exec.vector.accessor.reader.DictEntryReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import org.apache.drill.exec.vector.accessor.reader.ReaderEvents;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public class DictReaderImpl
extends ArrayReaderImpl
implements DictReader,
ReaderEvents {
    private final ScalarReader keyReader;
    private final AbstractObjectReader valueReader;
    private final KeyAccessor keyAccessor;

    public DictReaderImpl(ColumnMetadata metadata, VectorAccessor va, AbstractTupleReader.TupleObjectReader entryObjectReader) {
        super(metadata, va, entryObjectReader);
        DictEntryReader reader = (DictEntryReader)entryObjectReader.reader();
        this.keyReader = reader.keyReader().scalar();
        this.valueReader = reader.valueReader();
        this.keyAccessor = KeyAccessors.getAccessor(this, this.keyReader);
    }

    public static DictObjectReader build(ColumnMetadata schema, VectorAccessor dictAccessor, List<AbstractObjectReader> readers) {
        AbstractTupleReader.TupleObjectReader entryReader = DictEntryReader.build(schema, dictAccessor, readers);
        DictReaderImpl dictReader = new DictReaderImpl(schema, dictAccessor, entryReader);
        dictReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new DictObjectReader(dictReader);
    }

    @Override
    public KeyAccessor keyAccessor() {
        return this.keyAccessor;
    }

    @Override
    public ObjectReader valueReader() {
        return this.valueReader;
    }

    @Override
    public ValueType keyColumnType() {
        return this.keyReader.valueType();
    }

    @Override
    public ObjectType valueColumnType() {
        return this.valueReader.type();
    }

    @Override
    public Map<Object, Object> getObject() {
        this.rewind();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        while (this.next()) {
            map.put(this.keyReader.getObject(), this.valueReader.getObject());
        }
        return map;
    }

    @Override
    public String getAsString() {
        this.rewind();
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        boolean comma = false;
        while (this.next()) {
            if (comma) {
                buf.append(", ");
            }
            buf.append(this.keyReader.getAsString()).append(':').append(this.valueReader.getAsString());
            comma = true;
        }
        buf.append("}");
        return buf.toString();
    }

    public static class DictObjectReader
    extends ArrayReaderImpl.ArrayObjectReader {
        public DictObjectReader(DictReaderImpl dictReader) {
            super(dictReader);
        }

        @Override
        public DictReader dict() {
            return (DictReader)this.array();
        }
    }
}

