/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor.reader;

import java.util.List;
import org.apache.drill.exec.record.metadata.ColumnMetadata;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.vector.accessor.ColumnReaderIndex;
import org.apache.drill.exec.vector.accessor.reader.AbstractObjectReader;
import org.apache.drill.exec.vector.accessor.reader.AbstractTupleReader;
import org.apache.drill.exec.vector.accessor.reader.NullStateReaders;
import org.apache.drill.exec.vector.accessor.reader.VectorAccessor;

public class DictEntryReader
extends AbstractTupleReader {
    private final ColumnMetadata schema;
    private final VectorAccessor accessor;

    protected DictEntryReader(ColumnMetadata schema, VectorAccessor accessor, AbstractObjectReader[] readers) {
        super(readers);
        assert (readers.length == 2);
        this.schema = schema;
        this.accessor = accessor;
    }

    public static AbstractTupleReader.TupleObjectReader build(ColumnMetadata schema, VectorAccessor accessor, AbstractObjectReader[] readers) {
        DictEntryReader entryReader = new DictEntryReader(schema, accessor, readers);
        entryReader.bindNullState(NullStateReaders.REQUIRED_STATE_READER);
        return new AbstractTupleReader.TupleObjectReader(entryReader);
    }

    public static AbstractTupleReader.TupleObjectReader build(ColumnMetadata schema, VectorAccessor accessor, List<AbstractObjectReader> readers) {
        AbstractObjectReader[] readerArray = new AbstractObjectReader[readers.size()];
        return DictEntryReader.build(schema, accessor, readers.toArray(readerArray));
    }

    public AbstractObjectReader keyReader() {
        return (AbstractObjectReader)this.column(0);
    }

    public AbstractObjectReader valueReader() {
        return (AbstractObjectReader)this.column(1);
    }

    @Override
    public void bindIndex(ColumnReaderIndex index) {
        if (this.accessor != null) {
            this.accessor.bind(index);
        }
        super.bindIndex(index);
    }

    @Override
    public ColumnMetadata schema() {
        return this.schema;
    }

    @Override
    public TupleMetadata tupleSchema() {
        return this.schema.tupleSchema();
    }
}

