/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import java.sql.Timestamp;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.TimeStampVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class TimeStampAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.TIMESTAMP);
    private final TimeStampVector.Accessor ac;

    public TimeStampAccessor(TimeStampVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return Timestamp.class;
    }

    @Override
    public Object getObject(int index) {
        return this.getTimestamp(index);
    }

    @Override
    public Timestamp getTimestamp(int index) {
        LocalDateTime dateTime = new LocalDateTime(this.ac.get(index), DateTimeZone.UTC);
        return new Timestamp(dateTime.toDate().getTime());
    }
}

