/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector.accessor;

import io.netty.buffer.ByteBufInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.holders.NullableVarCharHolder;
import org.apache.drill.exec.vector.NullableVarCharVector;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;

public class NullableVarCharAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.optional(TypeProtos.MinorType.VARCHAR);
    private final NullableVarCharVector.Accessor ac;

    public NullableVarCharAccessor(NullableVarCharVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return this.ac.isNull(index);
    }

    @Override
    public InputStream getStream(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        NullableVarCharHolder h = new NullableVarCharHolder();
        this.ac.get(index, h);
        return new ByteBufInputStream(h.buffer.slice(h.start, h.end));
    }

    @Override
    public byte[] getBytes(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.ac.get(index);
    }

    @Override
    public Class<?> getObjectClass() {
        return String.class;
    }

    @Override
    public String getObject(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return this.getString(index);
    }

    @Override
    public InputStreamReader getReader(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new InputStreamReader(this.getStream(index), Charsets.UTF_8);
    }

    @Override
    public String getString(int index) {
        if (this.ac.isNull(index)) {
            return null;
        }
        return new String(this.getBytes(index), Charsets.UTF_8);
    }
}

