/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.vector;

import io.netty.buffer.DrillBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.exec.exception.OutOfMemoryException;
import org.apache.drill.exec.exception.OversizedAllocationException;
import org.apache.drill.exec.expr.holders.NullableVarBinaryHolder;
import org.apache.drill.exec.expr.holders.VarBinaryHolder;
import org.apache.drill.exec.memory.AllocationManager;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.vector.BaseDataValueVector;
import org.apache.drill.exec.vector.BaseValueVector;
import org.apache.drill.exec.vector.NullableVarBinaryVector;
import org.apache.drill.exec.vector.UInt4Vector;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.VarLenBulkEntry;
import org.apache.drill.exec.vector.VarLenBulkInput;
import org.apache.drill.exec.vector.VariableWidthVector;
import org.apache.drill.exec.vector.complex.impl.VarBinaryReaderImpl;
import org.apache.drill.exec.vector.complex.reader.FieldReader;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.apache.drill.shaded.guava.com.google.common.collect.ObjectArrays;

public final class VarBinaryVector
extends BaseDataValueVector
implements VariableWidthVector {
    private static final int INITIAL_BYTE_COUNT = Math.min(32768, MAX_BUFFER_SIZE);
    private final UInt4Vector offsetVector;
    private final FieldReader reader;
    private final Accessor accessor;
    private final Mutator mutator;
    private int allocationSizeInBytes;
    private int allocationMonitor;

    public VarBinaryVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
        this.offsetVector = new UInt4Vector(offsetsField, this.allocator);
        this.reader = new VarBinaryReaderImpl(this);
        this.allocationSizeInBytes = INITIAL_BYTE_COUNT;
        this.allocationMonitor = 0;
        this.accessor = new Accessor();
        this.mutator = new Mutator();
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSize() {
        if (this.getAccessor().getValueCount() == 0) {
            return 0;
        }
        return this.offsetVector.getBufferSize() + this.data.writerIndex();
    }

    @Override
    public int getAllocatedSize() {
        return this.offsetVector.getAllocatedSize() + this.data.capacity();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        int idx = this.offsetVector.getAccessor().get(valueCount);
        return this.offsetVector.getBufferSizeFor(valueCount + 1) + idx;
    }

    @Override
    public int getValueCapacity() {
        return Math.max(this.offsetVector.getValueCapacity() - 1, 0);
    }

    @Override
    public int getByteCapacity() {
        return this.data.capacity();
    }

    @Override
    public int getCurrentSizeInBytes() {
        return this.getVarByteLength();
    }

    public int getVarByteLength() {
        int valueCount = this.getAccessor().getValueCount();
        if (valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(valueCount);
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        return this.getMetadataBuilder().addChild(this.offsetVector.getMetadata()).setValueCount(this.getAccessor().getValueCount()).setBufferLength(this.getBufferSize()).build();
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        UserBitShared.SerializedField offsetField = metadata.getChild(0);
        this.offsetVector.load(offsetField, buffer);
        int capacity = buffer.capacity();
        int offsetsLength = offsetField.getBufferLength();
        this.data = buffer.slice(offsetsLength, capacity - offsetsLength);
        this.data.retain();
    }

    @Override
    public void clear() {
        super.clear();
        this.offsetVector.clear();
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        DrillBuf[] buffers = ObjectArrays.concat(this.offsetVector.getBuffers(false), super.getBuffers(false), DrillBuf.class);
        if (clear) {
            for (DrillBuf buffer : buffers) {
                buffer.retain(1);
            }
            this.clear();
        }
        return buffers;
    }

    public long getOffsetAddr() {
        return this.offsetVector.getBuffer().memoryAddress();
    }

    @Override
    public UInt4Vector getOffsetVector() {
        return this.offsetVector;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((VarBinaryVector)to);
    }

    public void transferTo(VarBinaryVector target) {
        target.clear();
        this.offsetVector.transferTo(target.offsetVector);
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, VarBinaryVector target) {
        UInt4Vector.Accessor offsetVectorAccessor = this.offsetVector.getAccessor();
        int startPoint = offsetVectorAccessor.get(startIndex);
        int sliceLength = offsetVectorAccessor.get(startIndex + length) - startPoint;
        target.clear();
        target.offsetVector.allocateNew(length + 1);
        offsetVectorAccessor = this.offsetVector.getAccessor();
        UInt4Vector.Mutator targetOffsetVectorMutator = target.offsetVector.getMutator();
        for (int i = 0; i < length + 1; ++i) {
            targetOffsetVectorMutator.set(i, offsetVectorAccessor.get(startIndex + i) - startPoint);
        }
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.getMutator().setValueCount(length);
    }

    protected void copyFrom(int fromIndex, int thisIndex, VarBinaryVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.data.getInt(thisIndex * 4);
        from.data.getBytes(start, this.data, outputStart, len);
        this.offsetVector.data.setInt((thisIndex + 1) * 4, outputStart + len);
    }

    public void copyFromSafe(int fromIndex, int thisIndex, VarBinaryVector from) {
        UInt4Vector.Accessor fromOffsetVectorAccessor = from.offsetVector.getAccessor();
        int start = fromOffsetVectorAccessor.get(fromIndex);
        int end = fromOffsetVectorAccessor.get(fromIndex + 1);
        int len = end - start;
        int outputStart = this.offsetVector.getAccessor().get(thisIndex);
        while (this.data.capacity() < outputStart + len) {
            this.reAlloc();
        }
        this.offsetVector.getMutator().setSafe(thisIndex + 1, outputStart + len);
        from.data.getBytes(start, this.data, outputStart, len);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (VarBinaryVector)from);
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
        this.offsetVector.collectLedgers(ledgers);
        super.collectLedgers(ledgers);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return this.offsetVector.getAccessor().get(valueCount) + this.offsetVector.getPayloadByteCount(valueCount);
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = 1L * (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
        this.offsetVector.setInitialCapacity(valueCount + 1);
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(4096L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize *= 2L;
            this.allocationMonitor = 0;
        }
        if (curAllocationSize > Integer.MAX_VALUE) {
            return false;
        }
        this.clear();
        try {
            int requestedSize = (int)curAllocationSize;
            this.data = this.allocator.buffer(requestedSize);
            this.allocationSizeInBytes = requestedSize;
            this.offsetVector.allocateNew();
        }
        catch (OutOfMemoryException e) {
            this.clear();
            return false;
        }
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        return true;
    }

    @Override
    public void allocateNew(int totalBytes, int valueCount) {
        this.clear();
        assert (totalBytes >= 0);
        try {
            this.data = this.allocator.buffer(totalBytes);
            this.offsetVector.allocateNew(valueCount + 1);
        }
        catch (RuntimeException e) {
            this.clear();
            throw e;
        }
        this.data.readerIndex(0);
        this.allocationSizeInBytes = totalBytes;
        this.offsetVector.zeroVector();
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = INITIAL_BYTE_COUNT;
        this.allocationMonitor = 0;
        this.data.readerIndex(0);
        this.offsetVector.zeroVector();
        super.reset();
    }

    public void reAlloc() {
        long newAllocationSize;
        for (newAllocationSize = (long)this.allocationSizeInBytes * 2L; newAllocationSize < (long)this.data.capacity(); newAllocationSize *= 2L) {
        }
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        this.data.release();
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return this.data;
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void exchange(ValueVector other) {
        super.exchange(other);
        VarBinaryVector target = (VarBinaryVector)other;
        this.offsetVector.exchange(target.offsetVector);
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableVarBinaryVector dest = (NullableVarBinaryVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor
    implements VariableWidthVector.VariableWidthAccessor {
        final UInt4Vector.Accessor oAccessor;

        public Accessor() {
            this.oAccessor = VarBinaryVector.this.offsetVector.getAccessor();
        }

        public long getStartEnd(int index) {
            return this.oAccessor.getTwoAsLong(index);
        }

        public byte[] get(int index) {
            assert (index >= 0);
            int startIdx = this.oAccessor.get(index);
            int length = this.oAccessor.get(index + 1) - startIdx;
            assert (length >= 0);
            byte[] dst = new byte[length];
            VarBinaryVector.this.data.getBytes(startIdx, dst, 0, length);
            return dst;
        }

        @Override
        public int getValueLength(int index) {
            UInt4Vector.Accessor offsetVectorAccessor = VarBinaryVector.this.offsetVector.getAccessor();
            return offsetVectorAccessor.get(index + 1) - offsetVectorAccessor.get(index);
        }

        public void get(int index, VarBinaryHolder holder) {
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarBinaryVector.this.data;
        }

        public void get(int index, NullableVarBinaryHolder holder) {
            holder.isSet = 1;
            holder.start = this.oAccessor.get(index);
            holder.end = this.oAccessor.get(index + 1);
            holder.buffer = VarBinaryVector.this.data;
        }

        public byte[] getObject(int index) {
            return this.get(index);
        }

        @Override
        public int getValueCount() {
            return Math.max(VarBinaryVector.this.offsetVector.getAccessor().getValueCount() - 1, 0);
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public UInt4Vector getOffsetVector() {
            return VarBinaryVector.this.offsetVector;
        }
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator
    implements VariableWidthVector.VariableWidthMutator {
        protected void set(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + bytes.length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
        }

        public void setSafe(int index, byte[] bytes) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            while (VarBinaryVector.this.data.capacity() < currentOffset + bytes.length) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + bytes.length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, 0, bytes.length);
        }

        public <T extends VarLenBulkEntry> void setSafe(VarLenBulkInput<T> input) {
            this.setSafe(input, null);
        }

        public <T extends VarLenBulkEntry> void setSafe(VarLenBulkInput<T> input, VarLenBulkInput.BulkInputCallback<T> callback) {
            VarLenBulkEntry entry;
            BufferedMutator bufferedMutator = new BufferedMutator(input.getStartIndex(), VarBinaryVector.this);
            while (input.hasNext() && (entry = (VarLenBulkEntry)input.next()) != null && entry.getNumValues() != 0) {
                bufferedMutator.setSafe(entry);
                if (callback != null) {
                    callback.onNewBulkEntry(entry);
                }
                DrillRuntimeException.checkInterrupted();
            }
            bufferedMutator.flush();
            input.done();
            if (callback != null) {
                callback.onEndBulkInput();
            }
        }

        protected void set(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        public void setSafe(int index, ByteBuffer bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            while (VarBinaryVector.this.data.capacity() < currentOffset + length) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        public void setSafe(int index, byte[] bytes, int start, int length) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            while (VarBinaryVector.this.data.capacity() < currentOffset + length) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, bytes, start, length);
        }

        @Override
        public void setValueLengthSafe(int index, int length) {
            int offset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            while (VarBinaryVector.this.data.capacity() < offset + length) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, VarBinaryVector.this.offsetVector.getAccessor().get(index) + length);
        }

        public void setSafe(int index, int start, int end, DrillBuf buffer) {
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                VarBinaryVector.this.reAlloc();
            }
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
            buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
        }

        public void setSafe(int index, NullableVarBinaryHolder holder) {
            assert (holder.isSet == 1);
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                VarBinaryVector.this.reAlloc();
            }
            holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        public void setSafe(int index, VarBinaryHolder holder) {
            int start = holder.start;
            int end = holder.end;
            int len = end - start;
            int outputStart = ((VarBinaryVector)VarBinaryVector.this).offsetVector.data.getInt(index * 4);
            while (VarBinaryVector.this.data.capacity() < outputStart + len) {
                VarBinaryVector.this.reAlloc();
            }
            holder.buffer.getBytes(start, VarBinaryVector.this.data, outputStart, len);
            VarBinaryVector.this.offsetVector.getMutator().setSafe(index + 1, outputStart + len);
        }

        public void fillEmpties(int lastWrite, int index) {
            int startWrite = lastWrite + 1;
            if (startWrite < index) {
                int fillOffset = VarBinaryVector.this.offsetVector.getAccessor().get(startWrite);
                UInt4Vector.Mutator offsetMutator = VarBinaryVector.this.offsetVector.getMutator();
                for (int i = startWrite; i < index; ++i) {
                    offsetMutator.setSafe(i + 1, fillOffset);
                }
            }
        }

        protected void set(int index, int start, int length, DrillBuf buffer) {
            assert (index >= 0);
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            DrillBuf bb = buffer.slice(start, length);
            VarBinaryVector.this.data.setBytes(currentOffset, bb);
        }

        protected void set(int index, NullableVarBinaryHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        protected void set(int index, VarBinaryHolder holder) {
            int length = holder.end - holder.start;
            int currentOffset = VarBinaryVector.this.offsetVector.getAccessor().get(index);
            VarBinaryVector.this.offsetVector.getMutator().set(index + 1, currentOffset + length);
            VarBinaryVector.this.data.setBytes(currentOffset, holder.buffer, holder.start, length);
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentByteCapacity = VarBinaryVector.this.getByteCapacity();
            int idx = valueCount == 0 && currentByteCapacity == 0 ? 0 : VarBinaryVector.this.offsetVector.getAccessor().get(valueCount);
            VarBinaryVector.this.data.writerIndex(idx);
            if (valueCount > 0 && currentByteCapacity > idx * 2) {
                VarBinaryVector.this.incrementAllocationMonitor();
            } else if (VarBinaryVector.this.allocationMonitor > 0) {
                VarBinaryVector.this.allocationMonitor = 0;
            }
            VarBinaryVector.this.offsetVector.getMutator().setValueCount(valueCount == 0 ? 0 : valueCount + 1);
        }

        @Override
        public void generateTestData(int size) {
            boolean even = true;
            Charset charset = Charsets.UTF_8;
            byte[] evenValue = "aaaaa".getBytes(charset);
            byte[] oddValue = "bbbbbbbbbb".getBytes(charset);
            for (int i = 0; i < size; ++i) {
                this.set(i, even ? evenValue : oddValue);
                even = !even;
            }
            this.setValueCount(size);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private final VarBinaryVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new VarBinaryVector(field, allocator);
        }

        public TransferImpl(VarBinaryVector to) {
            this.to = to;
        }

        @Override
        public VarBinaryVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            VarBinaryVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            VarBinaryVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, VarBinaryVector.this);
        }
    }

    public static final class BufferedMutator {
        private static final int DEFAULT_BUFF_SZ = 4096;
        private final ByteBuffer buffer = null;
        private final boolean enableDataBuffering = false;
        private int dataBuffOff;
        private int totalDataLen;
        private final VarBinaryVector parent;
        private final UInt4Vector.BufferedMutator offsetsMutator;

        public BufferedMutator(int startIdx, VarBinaryVector parent) {
            this(startIdx, 4096, parent);
        }

        public BufferedMutator(int startIdx, int buffSz, VarBinaryVector parent) {
            this.parent = parent;
            this.totalDataLen = this.dataBuffOff = this.parent.offsetVector.getAccessor().get(startIdx);
            this.offsetsMutator = new UInt4Vector.BufferedMutator(startIdx, buffSz, parent.offsetVector);
            this.offsetsMutator.setSafe(this.dataBuffOff);
        }

        public void setSafe(VarLenBulkEntry bulkEntry) {
            int[] lengths = bulkEntry.getValuesLength();
            int numValues = bulkEntry.getNumValues();
            this.setOffsets(lengths, numValues, bulkEntry.hasNulls());
            while (this.parent.data.capacity() < this.totalDataLen) {
                this.parent.reAlloc();
            }
            if (bulkEntry.arrayBacked()) {
                this.parent.data.setBytes(this.dataBuffOff, bulkEntry.getArrayData(), bulkEntry.getDataStartOffset(), bulkEntry.getTotalLength());
            } else {
                this.parent.data.setBytes(this.dataBuffOff, bulkEntry.getData(), bulkEntry.getDataStartOffset(), bulkEntry.getTotalLength());
            }
            this.dataBuffOff += bulkEntry.getTotalLength();
        }

        public void flush() {
            this.flushInternal();
            this.offsetsMutator.flush();
        }

        private void flushInternal() {
        }

        private void setOffsets(int[] lengths, int numValues, boolean hasNulls) {
            int toCopy;
            ByteBuffer offByteBuff = this.offsetsMutator.getByteBuffer();
            byte[] bufferArray = offByteBuff.array();
            int remaining = numValues;
            int srcPos = 0;
            do {
                int idx;
                if (offByteBuff.remaining() < 4) {
                    this.offsetsMutator.flush();
                }
                toCopy = Math.min(remaining, offByteBuff.remaining() / 4);
                int tgtPos = offByteBuff.position();
                if (!hasNulls) {
                    idx = 0;
                    while (idx < toCopy) {
                        this.totalDataLen += lengths[srcPos];
                        UInt4Vector.BufferedMutator.writeInt(this.totalDataLen, bufferArray, tgtPos);
                        ++idx;
                        tgtPos += 4;
                        ++srcPos;
                    }
                } else {
                    idx = 0;
                    while (idx < toCopy) {
                        int curr_len = lengths[srcPos];
                        this.totalDataLen += curr_len >= 0 ? curr_len : 0;
                        UInt4Vector.BufferedMutator.writeInt(this.totalDataLen, bufferArray, tgtPos);
                        ++idx;
                        tgtPos += 4;
                        ++srcPos;
                    }
                }
                offByteBuff.position(tgtPos);
            } while ((remaining -= toCopy) > 0);
            this.offsetsMutator.flush();
        }
    }
}

